/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.condition;

import cn.crane4j.annotation.condition.ConditionOnExpression;
import cn.crane4j.core.condition.AbstractConditionParser;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.expression.ExpressionContext;
import cn.crane4j.core.support.expression.ExpressionEvaluator;
import cn.crane4j.core.util.Asserts;
import java.lang.reflect.AnnotatedElement;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionOnExpressionParser
extends AbstractConditionParser<ConditionOnExpression> {
    private static final Logger log = LoggerFactory.getLogger(ConditionOnExpressionParser.class);
    public static final String VAR_TARGET = "target";
    public static final String VAR_OPERATION = "operation";
    private final ExpressionEvaluator expressionEvaluator;
    private final ContextFactory contextFactory;

    public ConditionOnExpressionParser(AnnotationFinder annotationFinder, ExpressionEvaluator expressionEvaluator, ContextFactory contextFactory) {
        super(annotationFinder, ConditionOnExpression.class);
        this.expressionEvaluator = expressionEvaluator;
        this.contextFactory = contextFactory;
    }

    @Override
    protected @Nullable AbstractConditionParser.AbstractCondition createCondition(AnnotatedElement element, ConditionOnExpression annotation) {
        String expression = annotation.value();
        Asserts.isNotEmpty(expression, "The property to be checked is not specified in the @{} on {}", this.annotationType.getSimpleName(), element);
        return new ExpressionCondition(expression);
    }

    @Override
    protected @NonNull AbstractConditionParser.ConditionDescriptor getConditionDescriptor(ConditionOnExpression annotation) {
        return ((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)((AbstractConditionParser.ConditionDescriptor.ConditionDescriptorBuilder)AbstractConditionParser.ConditionDescriptor.builder().boundOperationIds(annotation.id())).type(annotation.type())).sort(annotation.sort())).negate(annotation.negate())).build();
    }

    @FunctionalInterface
    public static interface ContextFactory {
        public ExpressionContext createContext(Object var1, KeyTriggerOperation var2);
    }

    private class ExpressionCondition
    extends AbstractConditionParser.AbstractCondition {
        private final String expression;

        @Override
        public boolean test(Object target, KeyTriggerOperation operation) {
            ExpressionContext context = ConditionOnExpressionParser.this.contextFactory.createContext(target, operation);
            context.registerVariable(ConditionOnExpressionParser.VAR_TARGET, target);
            context.registerVariable(ConditionOnExpressionParser.VAR_OPERATION, operation);
            return Boolean.TRUE.equals(ConditionOnExpressionParser.this.expressionEvaluator.execute(this.expression, Boolean.class, context));
        }

        public ExpressionCondition(String expression) {
            this.expression = expression;
        }
    }
}

