/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.container;

import cn.crane4j.annotation.DuplicateStrategy;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.util.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class MethodInvokerContainer
implements Container<Object> {
    protected final String namespace;
    protected final MethodInvoker methodInvoker;
    protected final @Nullable Object target;
    protected @Nullable MethodInvoker extractor;

    protected @Nullable Object extractIfPossible(@NonNull Object result) {
        return Objects.nonNull(this.extractor) ? this.extractor.invoke(result, new Object[0]) : result;
    }

    public static MethodInvokerContainer create(String namespace, MethodInvoker methodInvoker, @Nullable Object target, boolean isMapped) {
        return isMapped ? new NoMapping(namespace, methodInvoker, target) : new StandardMethodInvokerContainer(namespace, methodInvoker, target);
    }

    public static MethodInvokerContainer singleKey(String namespace, MethodInvoker methodInvoker, @Nullable Object target) {
        return new SingleKey(namespace, methodInvoker, target);
    }

    public static MethodInvokerContainer oneToOne(String namespace, MethodInvoker methodInvoker, @Nullable Object target, KeyExtractor keyExtractor, DuplicateStrategy duplicateStrategy) {
        return new OneToOne(namespace, methodInvoker, target, keyExtractor, duplicateStrategy);
    }

    public static MethodInvokerContainer oneToMany(String namespace, MethodInvoker methodInvoker, @Nullable Object target, KeyExtractor keyExtractor) {
        return new OneToMany(namespace, methodInvoker, target, keyExtractor);
    }

    public MethodInvokerContainer(String namespace, MethodInvoker methodInvoker, @Nullable Object target) {
        this.namespace = namespace;
        this.methodInvoker = methodInvoker;
        this.target = target;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public void setExtractor(@Nullable MethodInvoker extractor) {
        this.extractor = extractor;
    }

    @FunctionalInterface
    public static interface KeyExtractor {
        public Object getKey(Object var1);
    }

    protected static class OneToMany
    extends StandardMethodInvokerContainer {
        private final KeyExtractor keyExtractor;

        public OneToMany(String namespace, MethodInvoker methodInvoker, @Nullable Object target, KeyExtractor keyExtractor) {
            super(namespace, methodInvoker, target);
            this.keyExtractor = keyExtractor;
        }

        @Override
        protected Map<Object, ?> resolveResult(Collection<Object> keys, Object result) {
            Collection<?> results = CollectionUtils.adaptObjectToCollection(result);
            return results.stream().collect(Collectors.groupingBy(this.keyExtractor::getKey));
        }
    }

    protected static class OneToOne
    extends StandardMethodInvokerContainer {
        protected final KeyExtractor keyExtractor;
        private final DuplicateStrategy duplicateStrategy;

        public OneToOne(String namespace, MethodInvoker methodInvoker, @Nullable Object target, KeyExtractor keyExtractor, DuplicateStrategy duplicateStrategy) {
            super(namespace, methodInvoker, target);
            this.keyExtractor = keyExtractor;
            this.duplicateStrategy = duplicateStrategy;
        }

        @Override
        protected Map<Object, ?> resolveResult(Collection<Object> keys, Object result) {
            Collection<?> results = CollectionUtils.adaptObjectToCollection(result);
            HashMap resultMap = new HashMap(results.size());
            results.forEach(newVal -> {
                Object k = this.keyExtractor.getKey(newVal);
                resultMap.compute(k, (key, oldVal) -> Objects.isNull(oldVal) ? newVal : this.duplicateStrategy.choose(key, oldVal, newVal));
            });
            return resultMap;
        }
    }

    protected static class NoMapping
    extends StandardMethodInvokerContainer {
        public NoMapping(String namespace, MethodInvoker methodInvoker, @Nullable Object target) {
            super(namespace, methodInvoker, target);
        }

        @Override
        protected Map<Object, ?> resolveResult(Collection<Object> keys, Object result) {
            return (Map)result;
        }
    }

    protected static class StandardMethodInvokerContainer
    extends MethodInvokerContainer {
        public StandardMethodInvokerContainer(String namespace, MethodInvoker methodInvoker, @Nullable Object target) {
            super(namespace, methodInvoker, target);
        }

        @Override
        public Map<Object, ?> get(Collection<Object> keys) {
            Object[] arguments = this.resolveArguments(keys);
            return Optional.ofNullable(this.methodInvoker.invoke(this.target, arguments)).map(this::extractIfPossible).map(result -> this.resolveResult(keys, result)).orElse(Collections.emptyMap());
        }

        protected Object[] resolveArguments(Collection<Object> keys) {
            return new Object[]{keys};
        }

        protected Map<Object, ?> resolveResult(Collection<Object> keys, Object result) {
            Collection<?> results = CollectionUtils.adaptObjectToCollection(result);
            HashMap<Object, Object> resultMap = new HashMap<Object, Object>(keys.size());
            Iterator<?> valueIterator = results.iterator();
            for (Object key : keys) {
                Object value = valueIterator.hasNext() ? (Object)valueIterator.next() : null;
                resultMap.put(key, value);
            }
            return resultMap;
        }
    }

    protected static class SingleKey
    extends MethodInvokerContainer {
        public SingleKey(String namespace, MethodInvoker methodInvoker, @Nullable Object target) {
            super(namespace, methodInvoker, target);
        }

        @Override
        public Map<Object, ?> get(Collection<Object> keys) {
            HashMap results = new HashMap(keys.size());
            keys.forEach(key -> Optional.ofNullable(this.methodInvoker.invoke(this.target, key)).map(this::extractIfPossible).ifPresent(result -> results.put(key, result)));
            return results;
        }
    }
}

