/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.executor;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerManager;
import cn.crane4j.core.executor.AssembleExecution;
import cn.crane4j.core.executor.DisorderedBeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBeanOperationExecutor
extends DisorderedBeanOperationExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsyncBeanOperationExecutor.class);
    private final Executor executor;

    public AsyncBeanOperationExecutor(ContainerManager containerManager, Executor executor) {
        super(containerManager);
        this.executor = executor;
    }

    @Override
    protected void doExecuteOperations(Map<Container<?>, Map<AssembleOperationHandler, List<AssembleExecution>>> executionGroups) {
        ArrayList tasks = new ArrayList(executionGroups.size());
        executionGroups.forEach((c, he) -> he.forEach((h, es) -> tasks.add(() -> h.process((Container<?>)c, (Collection<AssembleExecution>)es))));
        tasks.stream().map(t -> CompletableFuture.runAsync(t, this.executor)).collect(Collectors.collectingAndThen(Collectors.toList(), ts -> CompletableFuture.allOf(ts.toArray(new CompletableFuture[0])))).join();
    }
}

