/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.parser.handler;

import cn.crane4j.annotation.AssembleEnum;
import cn.crane4j.annotation.ContainerEnum;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.EnumContainerBuilder;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.PropertyMapping;
import cn.crane4j.core.parser.SimplePropertyMapping;
import cn.crane4j.core.parser.handler.AbstractInternalProviderAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AbstractStandardAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AbstractStandardOperationAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssembleEnumAnnotationHandler
extends AbstractInternalProviderAssembleAnnotationHandler<AssembleEnum> {
    private static final Logger log = LoggerFactory.getLogger(AssembleEnumAnnotationHandler.class);
    private final PropertyOperator propertyOperator;

    public AssembleEnumAnnotationHandler(AnnotationFinder annotationFinder, Crane4jGlobalConfiguration globalConfiguration, PropertyOperator propertyOperator, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        this(annotationFinder, Crane4jGlobalSorter.comparator(), globalConfiguration, propertyOperator, propertyMappingStrategyManager);
    }

    public AssembleEnumAnnotationHandler(AnnotationFinder annotationFinder, Comparator<KeyTriggerOperation> operationComparator, Crane4jGlobalConfiguration globalConfiguration, PropertyOperator propertyOperator, PropertyMappingStrategyManager propertyMappingStrategyManager) {
        super(AssembleEnum.class, annotationFinder, operationComparator, globalConfiguration, propertyMappingStrategyManager);
        this.propertyOperator = propertyOperator;
    }

    @Override
    protected @NonNull Container<Object> createContainer(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleEnum> standardAnnotation, String namespace) {
        AssembleEnum annotation = (AssembleEnum)standardAnnotation.getAnnotation();
        Class<? extends Enum<?>> enumType = this.resolveEnumType(annotation);
        EnumContainerBuilder<Object, Enum<?>> builder = EnumContainerBuilder.of(enumType).namespace(namespace).annotationFinder(this.annotationFinder).propertyOperator(this.propertyOperator);
        if (annotation.followTypeConfig()) {
            return builder.build();
        }
        ContainerEnum containerEnum = annotation.enums();
        builder.key(containerEnum.key()).value(containerEnum.value()).duplicateStrategy(containerEnum.duplicateStrategy());
        return builder.build();
    }

    @Override
    protected String determineNamespace(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleEnum> standardAnnotation) {
        AssembleEnum annotation = (AssembleEnum)standardAnnotation.getAnnotation();
        Class<? extends Enum<?>> enumType = this.resolveEnumType(annotation);
        String config = annotation.followTypeConfig() ? "FollowTypeConfig" : annotation.enums().toString();
        return StringUtils.md5DigestAsHex(StringUtils.join(String::valueOf, "#", enumType, config));
    }

    private Class<? extends Enum<?>> resolveEnumType(AssembleEnum annotation) {
        Class<?> type = annotation.type();
        if (ClassUtils.isObjectOrVoid(type)) {
            type = ClassUtils.forName(annotation.typeName(), type);
            Asserts.isTrue(type.isEnum(), "type [{}] which specified in @AssembleEnum is not a enum type", type.getName());
        }
        return type;
    }

    @Override
    protected AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleEnum> getStandardAnnotation(BeanOperations beanOperations, AnnotatedElement element, AssembleEnum annotation) {
        return ((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardOperationAnnotationHandler.StandardAnnotationAdapter.StandardAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)((AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder)AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.builder().annotatedElement(element)).annotation(annotation)).id(annotation.id())).key(annotation.key())).keyResolver(annotation.keyResolver())).keyDesc(annotation.keyDesc())).sort(annotation.sort())).groups(annotation.groups())).keyType(annotation.keyType())).handler(annotation.handler())).handlerType(annotation.handlerType())).mappingTemplates(annotation.propTemplates())).props(annotation.props())).prop(annotation.prop())).propertyMappingStrategy(annotation.propertyMappingStrategy())).build();
    }

    @Override
    protected Set<PropertyMapping> parsePropertyMappings(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<AssembleEnum> standardAnnotation, String key) {
        Set<PropertyMapping> propertyMappings = super.parsePropertyMappings(standardAnnotation, key);
        AssembleEnum annotation = (AssembleEnum)standardAnnotation.getAnnotation();
        if (StringUtils.isNotEmpty(annotation.ref())) {
            propertyMappings.add(new SimplePropertyMapping("", annotation.ref()));
        }
        return propertyMappings;
    }
}

