/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.Containers;
import cn.crane4j.core.support.ContainerAdapterRegister;
import cn.crane4j.core.support.DataProvider;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultContainerAdapterRegister
implements ContainerAdapterRegister {
    public static final DefaultContainerAdapterRegister INSTANCE = new DefaultContainerAdapterRegister();
    protected final Map<Class<?>, ContainerAdapterRegister.Adapter> registeredAdapters = new LinkedHashMap();

    public DefaultContainerAdapterRegister() {
        this.initDefaultAdapters();
    }

    protected void initDefaultAdapters() {
        this.registerAdapter(Map.class, (n, t) -> Containers.forMap(n, (Map)t));
        this.registerAdapter(Container.class, (n, t) -> (Container)t);
        this.registerAdapter(DataProvider.class, (n, t) -> Containers.forLambda(n, (DataProvider)t));
    }

    @Override
    public @Nullable ContainerAdapterRegister.Adapter getAdapter(Class<?> targetType) {
        return this.findAdaptor(targetType);
    }

    @Override
    public void registerAdapter(Class<?> targetType, ContainerAdapterRegister.Adapter adapter) {
        this.registeredAdapters.put(targetType, adapter);
    }

    private @Nullable ContainerAdapterRegister.Adapter findAdaptor(Class<?> targetType) {
        ContainerAdapterRegister.Adapter adapter = this.registeredAdapters.get(targetType);
        if (Objects.nonNull(adapter)) {
            return adapter;
        }
        return this.registeredAdapters.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(targetType)).findFirst().map(Map.Entry::getValue).orElse(null);
    }
}

