/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support;

import cn.crane4j.core.cache.AbstractMapCacheManager;
import cn.crane4j.core.cache.CacheManager;
import cn.crane4j.core.cache.GuavaCacheManager;
import cn.crane4j.core.condition.ConditionOnContainerParser;
import cn.crane4j.core.condition.ConditionOnPropertyNotEmptyParser;
import cn.crane4j.core.condition.ConditionOnPropertyNotNullParser;
import cn.crane4j.core.condition.ConditionOnPropertyParser;
import cn.crane4j.core.condition.ConditionOnTargetTypeParser;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.DefaultContainerManager;
import cn.crane4j.core.container.lifecycle.ContainerRegisterLogger;
import cn.crane4j.core.executor.AsyncBeanOperationExecutor;
import cn.crane4j.core.executor.BeanOperationExecutor;
import cn.crane4j.core.executor.DisorderedBeanOperationExecutor;
import cn.crane4j.core.executor.OrderedBeanOperationExecutor;
import cn.crane4j.core.executor.handler.AssembleOperationHandler;
import cn.crane4j.core.executor.handler.DisassembleOperationHandler;
import cn.crane4j.core.executor.handler.ManyToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToManyAssembleOperationHandler;
import cn.crane4j.core.executor.handler.OneToOneAssembleOperationHandler;
import cn.crane4j.core.executor.handler.ReflectiveDisassembleOperationHandler;
import cn.crane4j.core.parser.BeanOperationParser;
import cn.crane4j.core.parser.ConditionalTypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.TypeHierarchyBeanOperationParser;
import cn.crane4j.core.parser.handler.AssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleConstantAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleEnumAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleKeyAnnotationHandler;
import cn.crane4j.core.parser.handler.AssembleMethodAnnotationHandler;
import cn.crane4j.core.parser.handler.DisassembleAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.OverwriteMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.OverwriteNotNullMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.handler.strategy.ReferenceMappingStrategy;
import cn.crane4j.core.parser.handler.strategy.SimplePropertyMappingStrategyManager;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.SimpleAnnotationFinder;
import cn.crane4j.core.support.SimpleTypeResolver;
import cn.crane4j.core.support.TypeResolver;
import cn.crane4j.core.support.container.DefaultMethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.HutoolConverterManager;
import cn.crane4j.core.support.reflect.CacheablePropertyOperator;
import cn.crane4j.core.support.reflect.ChainAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.MapAccessiblePropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.PropertyOperatorHolder;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ConfigurationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCrane4jGlobalConfiguration
extends DefaultContainerManager
implements Crane4jGlobalConfiguration {
    private final AnnotationFinder annotationFinder;
    private TypeResolver typeResolver;
    private PropertyOperator propertyOperator;
    private ConverterManager converterManager;
    private final Map<String, BeanOperationParser> beanOperationParserMap = new HashMap<String, BeanOperationParser>(16);
    private final Map<String, AssembleOperationHandler> assembleOperationHandlerMap = new HashMap<String, AssembleOperationHandler>(4);
    private final Map<String, DisassembleOperationHandler> disassembleOperationHandlerMap = new HashMap<String, DisassembleOperationHandler>(4);
    private final Map<String, BeanOperationExecutor> beanOperationExecutorMap = new HashMap<String, BeanOperationExecutor>(4);
    private final Map<String, CacheManager> cacheManagerMap = new HashMap<String, CacheManager>(4);
    private final PropertyMappingStrategyManager propertyMappingStrategyManager = new SimplePropertyMappingStrategyManager();

    @Deprecated
    public static SimpleCrane4jGlobalConfiguration create() {
        return SimpleCrane4jGlobalConfiguration.builder().build();
    }

    @Deprecated
    public static SimpleCrane4jGlobalConfiguration create(AnnotationFinder annotationFinder, ConverterManager converter, PropertyOperator operator) {
        return SimpleCrane4jGlobalConfiguration.builder().annotationFinder(annotationFinder).converterManager(converter).propertyOperator(operator).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public @NonNull BeanOperationExecutor getBeanOperationExecutor(@Nullable String executorName, Class<?> executorType) {
        BeanOperationExecutor executor = ConfigurationUtil.getComponentFromConfiguration(BeanOperationExecutor.class, executorType, executorName, (t, n) -> {
            BeanOperationExecutor r = this.beanOperationExecutorMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.beanOperationExecutorMap.get(t.getSimpleName()));
        Asserts.isNotNull(executor, "cannot find executor [{}]({})", executorName, executorType);
        return executor;
    }

    @Override
    public @NonNull BeanOperationParser getBeanOperationsParser(@Nullable String parserName, Class<?> parserType) {
        BeanOperationParser parser = ConfigurationUtil.getComponentFromConfiguration(BeanOperationParser.class, parserType, parserName, (t, n) -> {
            BeanOperationParser r = this.beanOperationParserMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.beanOperationParserMap.get(t.getSimpleName()));
        Asserts.isNotNull(parser, "cannot find parser [{}]({})", parserName, parserType);
        return parser;
    }

    @Override
    public @NonNull AssembleOperationHandler getAssembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        AssembleOperationHandler parser = ConfigurationUtil.getComponentFromConfiguration(AssembleOperationHandler.class, handlerType, handlerName, (t, n) -> {
            AssembleOperationHandler r = this.assembleOperationHandlerMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.assembleOperationHandlerMap.get(t.getSimpleName()));
        Asserts.isNotNull(parser, "cannot find assemble handler [{}]({})", handlerName, handlerType);
        return parser;
    }

    @Override
    public @NonNull DisassembleOperationHandler getDisassembleOperationHandler(@Nullable String handlerName, Class<?> handlerType) {
        DisassembleOperationHandler parser = ConfigurationUtil.getComponentFromConfiguration(DisassembleOperationHandler.class, handlerType, handlerName, (t, n) -> {
            DisassembleOperationHandler r = this.disassembleOperationHandlerMap.get(n);
            return t.isAssignableFrom(r.getClass()) ? r : null;
        }, t -> this.disassembleOperationHandlerMap.get(t.getSimpleName()));
        Asserts.isNotNull(parser, "cannot find disassemble handler [{}]({})", handlerName, handlerType);
        return parser;
    }

    @Override
    public @NonNull CacheManager getCacheManager(String name) {
        CacheManager factory = this.cacheManagerMap.get(name);
        Asserts.isNotNull(factory, "cannot find cache manager [{}]", name);
        return factory;
    }

    @Override
    public void registerCacheManager(CacheManager cacheManager) {
        this.cacheManagerMap.put(cacheManager.getName(), cacheManager);
    }

    private SimpleCrane4jGlobalConfiguration(AnnotationFinder annotationFinder, TypeResolver typeResolver, PropertyOperator propertyOperator, ConverterManager converterManager) {
        this.annotationFinder = annotationFinder;
        this.typeResolver = typeResolver;
        this.propertyOperator = propertyOperator;
        this.converterManager = converterManager;
    }

    public AnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public PropertyOperator getPropertyOperator() {
        return this.propertyOperator;
    }

    @Override
    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    public Map<String, BeanOperationParser> getBeanOperationParserMap() {
        return this.beanOperationParserMap;
    }

    public Map<String, AssembleOperationHandler> getAssembleOperationHandlerMap() {
        return this.assembleOperationHandlerMap;
    }

    public Map<String, DisassembleOperationHandler> getDisassembleOperationHandlerMap() {
        return this.disassembleOperationHandlerMap;
    }

    public Map<String, BeanOperationExecutor> getBeanOperationExecutorMap() {
        return this.beanOperationExecutorMap;
    }

    public Map<String, CacheManager> getCacheManagerMap() {
        return this.cacheManagerMap;
    }

    public PropertyMappingStrategyManager getPropertyMappingStrategyManager() {
        return this.propertyMappingStrategyManager;
    }

    public void setTypeResolver(TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void setPropertyOperator(PropertyOperator propertyOperator) {
        this.propertyOperator = propertyOperator;
    }

    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    @Override
    public void addPropertyMappingStrategy(PropertyMappingStrategy propertyMappingStrategy) {
        this.getPropertyMappingStrategyManager().addPropertyMappingStrategy(propertyMappingStrategy);
    }

    @Override
    public PropertyMappingStrategy getPropertyMappingStrategy(String name) {
        return this.getPropertyMappingStrategyManager().getPropertyMappingStrategy(name);
    }

    @Override
    public PropertyMappingStrategy removePropertyMappingStrategy(String name) {
        return this.getPropertyMappingStrategyManager().removePropertyMappingStrategy(name);
    }

    @Override
    public Collection<PropertyMappingStrategy> getAllPropertyMappingStrategies() {
        return this.getPropertyMappingStrategyManager().getAllPropertyMappingStrategies();
    }

    public static class Builder {
        private @NonNull AnnotationFinder annotationFinder = SimpleAnnotationFinder.INSTANCE;
        private @NonNull ConverterManager converterManager = HutoolConverterManager.INSTANCE;
        private @NonNull PropertyOperator propertyOperator = new ReflectivePropertyOperator(HutoolConverterManager.INSTANCE);
        private boolean enablePropertyOperatorDecorator = true;
        private @NonNull TypeResolver typeResolver = new SimpleTypeResolver();

        public SimpleCrane4jGlobalConfiguration build() {
            if (this.enablePropertyOperatorDecorator) {
                this.propertyOperator = new CacheablePropertyOperator(this.propertyOperator);
                this.propertyOperator = new MapAccessiblePropertyOperator(this.propertyOperator);
                this.propertyOperator = new ChainAccessiblePropertyOperator(this.propertyOperator);
                this.propertyOperator = new PropertyOperatorHolder(this.propertyOperator);
            }
            SimpleCrane4jGlobalConfiguration configuration = new SimpleCrane4jGlobalConfiguration(this.annotationFinder, this.typeResolver, this.propertyOperator, this.converterManager);
            Builder.initDefaultContainerComponents(configuration);
            this.initDefaultParserComponents(configuration);
            this.initDefaultExecutorComponents(configuration);
            Builder.initDefaultCacheComponents(configuration);
            return configuration;
        }

        private static void initDefaultCacheComponents(SimpleCrane4jGlobalConfiguration configuration) {
            GuavaCacheManager guavaCacheManager = new GuavaCacheManager();
            configuration.getCacheManagerMap().put(guavaCacheManager.getName(), guavaCacheManager);
            AbstractMapCacheManager mapCacheManager = AbstractMapCacheManager.newWeakConcurrentMapCacheManager();
            configuration.getCacheManagerMap().put(mapCacheManager.getName(), mapCacheManager);
        }

        private static void initDefaultContainerComponents(SimpleCrane4jGlobalConfiguration configuration) {
            Logger logger = LoggerFactory.getLogger(ContainerRegisterLogger.class);
            configuration.registerContainerLifecycleProcessor(new ContainerRegisterLogger((arg_0, arg_1) -> ((Logger)logger).info(arg_0, arg_1)));
            configuration.registerContainerProvider(configuration.getClass().getSimpleName(), configuration);
            configuration.registerContainerProvider(ContainerProvider.class.getSimpleName(), configuration);
        }

        private void initDefaultParserComponents(SimpleCrane4jGlobalConfiguration configuration) {
            ConditionalTypeHierarchyBeanOperationParser beanOperationParser = new ConditionalTypeHierarchyBeanOperationParser();
            beanOperationParser.registerConditionParser(new ConditionOnPropertyParser(this.annotationFinder, this.propertyOperator, this.converterManager));
            beanOperationParser.registerConditionParser(new ConditionOnPropertyNotNullParser(this.annotationFinder, this.propertyOperator));
            beanOperationParser.registerConditionParser(new ConditionOnPropertyNotEmptyParser(this.annotationFinder, this.propertyOperator));
            beanOperationParser.registerConditionParser(new ConditionOnTargetTypeParser(this.annotationFinder));
            beanOperationParser.registerConditionParser(new ConditionOnContainerParser(this.annotationFinder, configuration));
            configuration.getBeanOperationParserMap().put(BeanOperationParser.class.getSimpleName(), beanOperationParser);
            configuration.getBeanOperationParserMap().put(TypeHierarchyBeanOperationParser.class.getSimpleName(), beanOperationParser);
            configuration.getBeanOperationParserMap().put(beanOperationParser.getName(), beanOperationParser);
            AssembleAnnotationHandler assembleAnnotationHandler = new AssembleAnnotationHandler(this.annotationFinder, configuration, configuration);
            beanOperationParser.addOperationAnnotationHandler(assembleAnnotationHandler);
            AssembleEnumAnnotationHandler assembleEnumAnnotationHandler = new AssembleEnumAnnotationHandler(this.annotationFinder, configuration, this.propertyOperator, configuration);
            beanOperationParser.addOperationAnnotationHandler(assembleEnumAnnotationHandler);
            DisassembleAnnotationHandler disassembleAnnotationHandler = new DisassembleAnnotationHandler(this.annotationFinder, configuration);
            beanOperationParser.addOperationAnnotationHandler(disassembleAnnotationHandler);
            MethodInvokerContainerCreator creator = new MethodInvokerContainerCreator(configuration.getPropertyOperator(), configuration.getConverterManager());
            AssembleMethodAnnotationHandler annotationHandler = new AssembleMethodAnnotationHandler(this.annotationFinder, configuration, Collections.singletonList(new DefaultMethodContainerFactory(creator, this.annotationFinder)), new SimplePropertyMappingStrategyManager());
            beanOperationParser.addOperationAnnotationHandler(annotationHandler);
            AssembleConstantAnnotationHandler assembleConstantAnnotationHandler = new AssembleConstantAnnotationHandler(this.annotationFinder, configuration, configuration);
            beanOperationParser.addOperationAnnotationHandler(assembleConstantAnnotationHandler);
            AssembleKeyAnnotationHandler assembleKeyAnnotationHandler = new AssembleKeyAnnotationHandler(this.annotationFinder, configuration, configuration);
            beanOperationParser.addOperationAnnotationHandler(assembleKeyAnnotationHandler);
        }

        private void initDefaultExecutorComponents(SimpleCrane4jGlobalConfiguration configuration) {
            DisorderedBeanOperationExecutor disorderedBeanOperationExecutor = new DisorderedBeanOperationExecutor(configuration);
            configuration.getBeanOperationExecutorMap().put(BeanOperationExecutor.class.getSimpleName(), disorderedBeanOperationExecutor);
            configuration.getBeanOperationExecutorMap().put(disorderedBeanOperationExecutor.getName(), disorderedBeanOperationExecutor);
            OrderedBeanOperationExecutor orderedBeanOperationExecutor = new OrderedBeanOperationExecutor(configuration, Crane4jGlobalSorter.comparator());
            configuration.getBeanOperationExecutorMap().put(orderedBeanOperationExecutor.getName(), orderedBeanOperationExecutor);
            int corePoolSize = Runtime.getRuntime().availableProcessors();
            ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize * 2, corePoolSize * 2, 10L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), new ThreadPoolExecutor.CallerRunsPolicy());
            executor.allowCoreThreadTimeOut(true);
            AsyncBeanOperationExecutor asyncBeanOperationExecutor = new AsyncBeanOperationExecutor(configuration, executor);
            configuration.getBeanOperationExecutorMap().put(asyncBeanOperationExecutor.getName(), asyncBeanOperationExecutor);
            configuration.addPropertyMappingStrategy(OverwriteMappingStrategy.INSTANCE);
            configuration.addPropertyMappingStrategy(OverwriteNotNullMappingStrategy.INSTANCE);
            configuration.addPropertyMappingStrategy(new ReferenceMappingStrategy(this.propertyOperator));
            OneToOneAssembleOperationHandler oneToOneReflexAssembleOperationHandler = new OneToOneAssembleOperationHandler(this.propertyOperator, this.converterManager);
            configuration.getAssembleOperationHandlerMap().put(AssembleOperationHandler.class.getSimpleName(), oneToOneReflexAssembleOperationHandler);
            configuration.getAssembleOperationHandlerMap().put(oneToOneReflexAssembleOperationHandler.getName(), oneToOneReflexAssembleOperationHandler);
            OneToManyAssembleOperationHandler oneToManyReflexAssembleOperationHandler = new OneToManyAssembleOperationHandler(this.propertyOperator, this.converterManager);
            configuration.getAssembleOperationHandlerMap().put(oneToManyReflexAssembleOperationHandler.getName(), oneToManyReflexAssembleOperationHandler);
            ManyToManyAssembleOperationHandler manyToManyReflexAssembleOperationHandler = new ManyToManyAssembleOperationHandler(this.propertyOperator, this.converterManager);
            configuration.getAssembleOperationHandlerMap().put(manyToManyReflexAssembleOperationHandler.getName(), manyToManyReflexAssembleOperationHandler);
            ReflectiveDisassembleOperationHandler reflectiveDisassembleOperationHandler = new ReflectiveDisassembleOperationHandler(this.propertyOperator);
            configuration.getDisassembleOperationHandlerMap().put(DisassembleOperationHandler.class.getSimpleName(), reflectiveDisassembleOperationHandler);
            configuration.getDisassembleOperationHandlerMap().put(reflectiveDisassembleOperationHandler.getName(), reflectiveDisassembleOperationHandler);
        }

        public Builder annotationFinder(@NonNull AnnotationFinder annotationFinder) {
            if (annotationFinder == null) {
                throw new NullPointerException("annotationFinder is marked non-null but is null");
            }
            this.annotationFinder = annotationFinder;
            return this;
        }

        public Builder converterManager(@NonNull ConverterManager converterManager) {
            if (converterManager == null) {
                throw new NullPointerException("converterManager is marked non-null but is null");
            }
            this.converterManager = converterManager;
            return this;
        }

        public Builder propertyOperator(@NonNull PropertyOperator propertyOperator) {
            if (propertyOperator == null) {
                throw new NullPointerException("propertyOperator is marked non-null but is null");
            }
            this.propertyOperator = propertyOperator;
            return this;
        }

        public Builder enablePropertyOperatorDecorator(boolean enablePropertyOperatorDecorator) {
            this.enablePropertyOperatorDecorator = enablePropertyOperatorDecorator;
            return this;
        }

        public Builder typeResolver(@NonNull TypeResolver typeResolver) {
            if (typeResolver == null) {
                throw new NullPointerException("typeResolver is marked non-null but is null");
            }
            this.typeResolver = typeResolver;
            return this;
        }
    }
}

