/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.Crane4jGlobalSorter;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.StringUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContainerMethodSupport {
    private static final Logger log = LoggerFactory.getLogger(AbstractContainerMethodSupport.class);
    protected final List<MethodContainerFactory> methodContainerFactories;

    protected AbstractContainerMethodSupport(Collection<MethodContainerFactory> methodContainerFactories) {
        this.methodContainerFactories = methodContainerFactories.stream().sorted(Crane4jGlobalSorter.comparator()).collect(Collectors.toList());
    }

    public void registerMethodContainerFactory(@NonNull MethodContainerFactory methodContainerFactory) {
        if (!this.methodContainerFactories.contains(methodContainerFactory)) {
            this.methodContainerFactories.add(methodContainerFactory);
            this.methodContainerFactories.sort(Crane4jGlobalSorter.comparator());
        }
    }

    protected Collection<Container<Object>> createMethodContainer(@Nullable Object bean, Method method, Collection<ContainerMethod> annotations) {
        return this.methodContainerFactories.stream().filter(factory -> factory.support(bean, method, annotations)).findFirst().map(factory -> factory.get(bean, method, annotations)).orElse(Collections.emptyList());
    }

    protected @Nullable Method findMatchedMethodForAnnotation(List<Method> methods, ContainerMethod annotation) {
        Map<String, List<Method>> methodGroup = methods.stream().collect(Collectors.groupingBy(Method::getName));
        String methodName = StringUtils.emptyToDefault(annotation.bindMethod(), annotation.namespace());
        List<Method> candidates = methodGroup.get(methodName);
        Asserts.isNotEmpty(candidates, "bound method not found: {}({})", annotation.bindMethod(), StringUtils.join(Class::getName, ", ", annotation.bindMethodParamTypes()));
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        Method matched = this.findMostMatchMethod(candidates, annotation.bindMethodParamTypes());
        if (Objects.nonNull(matched)) {
            return matched;
        }
        if (log.isDebugEnabled()) {
            log.debug("bound method not found: [{}] ({})", (Object)annotation.bindMethod(), Arrays.asList(annotation.bindMethodParamTypes()));
        }
        return null;
    }

    protected @Nullable Method findMostMatchMethod(@NonNull List<Method> candidates, @NonNull Class<?>[] expectedTypes) {
        int[] matchCounts = new int[candidates.size()];
        Arrays.fill(matchCounts, 0);
        Method mostMatchedMethod = this.matchMethods(candidates, matchCounts, expectedTypes);
        if (Objects.nonNull(mostMatchedMethod)) {
            return mostMatchedMethod;
        }
        int indexOfMostMatchMethod = -1;
        for (int i = 1; i < matchCounts.length; ++i) {
            int matchCount = matchCounts[i];
            if (matchCount < 0 || indexOfMostMatchMethod >= 0 && matchCount <= matchCounts[indexOfMostMatchMethod]) continue;
            indexOfMostMatchMethod = i;
        }
        return indexOfMostMatchMethod < 0 ? null : candidates.get(indexOfMostMatchMethod);
    }

    private Method matchMethods(List<Method> candidates, int[] matchCounts, Class<?>[] expectedTypes) {
        int expectedCount = expectedTypes.length;
        for (int i = 0; i < candidates.size(); ++i) {
            Method curr = candidates.get(i);
            Class<?>[] actualTypes = curr.getParameterTypes();
            int actualCount = actualTypes.length;
            if (actualCount < expectedCount) {
                matchCounts[i] = -1;
                continue;
            }
            int matchCount = 0;
            for (int j = 0; j < expectedCount; ++j) {
                if (!expectedTypes[j].isAssignableFrom(actualTypes[j])) {
                    matchCounts[i] = -1;
                    break;
                }
                ++matchCount;
            }
            if (matchCount == expectedCount && actualCount == expectedCount) {
                return curr;
            }
            matchCounts[i] = matchCount;
        }
        return null;
    }
}

