/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.FilterableKeyContainer;
import cn.crane4j.core.container.MethodInvokerContainer;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMethodContainerFactory
implements MethodContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultMethodContainerFactory.class);
    protected final MethodInvokerContainerCreator methodInvokerContainerCreator;
    protected final AnnotationFinder annotationFinder;

    public DefaultMethodContainerFactory(MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder) {
        this.methodInvokerContainerCreator = methodInvokerContainerCreator;
        this.annotationFinder = annotationFinder;
    }

    @Override
    public int getSort() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean support(@Nullable Object source, Method method, Collection<ContainerMethod> annotations) {
        return !Objects.equals(method.getReturnType(), Void.TYPE);
    }

    @Override
    public List<Container<Object>> get(@Nullable Object source, Method method, Collection<ContainerMethod> annotations) {
        return annotations.stream().map(annotation -> this.createContainer(source, method, (ContainerMethod)annotation)).collect(Collectors.toList());
    }

    private Container<Object> createContainer(Object source, Method method, ContainerMethod annotation) {
        MethodInvokerContainerCreator.MethodInvokerContainerCreation containerCreation = MethodInvokerContainerCreator.MethodInvokerContainerCreation.builder().target(source).method(method).mappingType(annotation.type()).namespace(annotation.namespace()).resultType(annotation.resultType()).resultKey(annotation.resultKey()).duplicateStrategy(annotation.duplicateStrategy()).on(annotation.on()).build();
        MethodInvokerContainer container = this.methodInvokerContainerCreator.createContainer(containerCreation);
        return this.wrapIfNecessary(container, method, annotation);
    }

    private Container<Object> wrapIfNecessary(Container<Object> container, Method method, ContainerMethod annotation) {
        if (!annotation.filterNullKey() || !annotation.skipQueryIfKeyCollIsEmpty()) {
            return container;
        }
        FilterableKeyContainer<Object> wrapper = new FilterableKeyContainer<Object>(container);
        wrapper.setFilterNullKey(annotation.filterNullKey());
        wrapper.setSkipQueryIfKeyCollIsEmpty(annotation.skipQueryIfKeyCollIsEmpty());
        if (annotation.skipQueryIfKeyCollIsEmpty() && method.getParameterCount() == 0) {
            log.warn("The container method [{}] has no parameters, but it is set skipQueryIfKeyCollIsEmpty= true, Therefore, the method will never be called. Is this correct?", (Object)method);
        }
        return wrapper;
    }
}

