/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.proxy;

import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.support.proxy.ProxyFactory;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProxyFactory
implements ProxyFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultProxyFactory.class);
    public static final DefaultProxyFactory INSTANCE = new DefaultProxyFactory();

    @Override
    public <T> T createProxy(InvocationHandler handler, Class<?> ... proxyTypes) {
        Asserts.isNotEmpty(proxyTypes, "Proxy types must not be empty", new Object[0]);
        proxyTypes = ArrayUtils.append(proxyTypes, ProxyFactory.Proxied.class);
        if (Stream.of(proxyTypes).allMatch(Class::isInterface)) {
            return this.createProxyByJdk(handler, proxyTypes);
        }
        Map types = Stream.of(proxyTypes).collect(Collectors.partitioningBy(Class::isInterface, Collectors.toSet()));
        Class<?> parent = DefaultProxyFactory.determineParentType(types.get(false));
        ArrayList interfaces = new ArrayList(types.get(true));
        return this.createProxyByByteBuddy(handler, parent, interfaces);
    }

    private <T> @NonNull T createProxyByJdk(InvocationHandler handler, Class<?>[] proxyTypes) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), proxyTypes, handler);
    }

    private <T> @NonNull T createProxyByByteBuddy(InvocationHandler handler, Class<?> parent, List<Class<?>> interfaces) {
        try {
            Class<?> proxyType = DefaultProxyFactory.makeProxyType(handler, parent, interfaces);
            return (T)proxyType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to create proxy object", (Throwable)e);
            throw new Crane4jException(e);
        }
    }

    private static @NonNull Class<?> makeProxyType(InvocationHandler handler, Class<?> parent, List<Class<?>> interfaces) {
        DynamicType.Loaded dynamicTypeloaded = new ByteBuddy().subclass(parent).implement(interfaces).method(ModifierReviewable.OfByteCodeElement::isPublic).intercept((Implementation)InvocationHandlerAdapter.of((InvocationHandler)handler)).make().load(Thread.currentThread().getContextClassLoader());
        return dynamicTypeloaded.getLoaded();
    }

    private static @NonNull Class<?> determineParentType(@Nullable Set<Class<?>> candidates) {
        Asserts.isNotNull(candidates, "No parent type candidates provided", new Object[0]);
        Asserts.isTrue(candidates.size() == 1, "Only one parent class is allowed, but got: " + candidates, new Object[0]);
        Class<?> parent = CollectionUtils.getFirstNotNull(candidates);
        return Objects.isNull(parent) ? Object.class : parent;
    }
}

