/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.query;

import cn.crane4j.core.container.Container;
import cn.crane4j.core.parser.BeanOperations;
import cn.crane4j.core.parser.handler.AbstractInternalProviderAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.AbstractStandardAssembleAnnotationHandler;
import cn.crane4j.core.parser.handler.strategy.PropertyMappingStrategyManager;
import cn.crane4j.core.parser.operation.KeyTriggerOperation;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.Crane4jGlobalConfiguration;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.support.query.QueryDefinition;
import cn.crane4j.core.support.query.QueryRepository;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryAssembleAnnotationHandler<A extends Annotation, R>
extends AbstractInternalProviderAssembleAnnotationHandler<A> {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryAssembleAnnotationHandler.class);
    protected static final String NAMESPACE_TEMPLATE = "@{}#{}#{}#{}#{}";
    protected final Map<String, QueryRepository<R>> ormRepositoryMap;
    private final MethodInvokerContainerCreator methodInvokerContainerCreator;
    private @Nullable RepositoryTargetProvider<R> repositoryTargetProvider;

    protected AbstractQueryAssembleAnnotationHandler(Class<A> annotationType, AnnotationFinder annotationFinder, @NonNull Comparator<KeyTriggerOperation> operationComparator, Crane4jGlobalConfiguration globalConfiguration, PropertyMappingStrategyManager propertyMappingStrategyManager, MethodInvokerContainerCreator methodInvokerContainerCreator) {
        super(annotationType, annotationFinder, operationComparator, globalConfiguration, propertyMappingStrategyManager);
        this.methodInvokerContainerCreator = methodInvokerContainerCreator;
        this.ormRepositoryMap = new HashMap<String, QueryRepository<R>>();
    }

    @Override
    protected final @NonNull Container<Object> createContainer(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<A> standardAnnotation, String namespace) {
        OrmAssembleAnnotation annotation = (OrmAssembleAnnotation)standardAnnotation;
        QueryRepository<R> repository = this.getRepository(annotation);
        Asserts.isNotNull(repository, "cannot find repository for annotation {}", annotation);
        MethodInvoker invoker = this.createMethodInvoker(annotation, repository);
        QueryDefinition definition = annotation.getQueryDefinition();
        MethodInvokerContainerCreator.MethodInvokerContainerCreation containerCreation = MethodInvokerContainerCreator.MethodInvokerContainerCreation.builder().target(repository.getTarget()).methodInvoker(invoker).mappingType(definition.getMappingType()).namespace(namespace).resultType(repository.getEntityType()).resultKey(StringUtils.emptyToDefault(definition.getConditionColumn(), repository.getPrimaryKeyProperty())).duplicateStrategy(definition.getDuplicateStrategy()).build();
        return this.methodInvokerContainerCreator.createContainer(containerCreation);
    }

    private MethodInvoker createMethodInvoker(OrmAssembleAnnotation<A> annotation, QueryRepository<R> repository) {
        QueryDefinition queryDefinition = annotation.getQueryDefinition();
        Set<String> selectColumns = queryDefinition.getSelectColumns().stream().map(repository::resolveToColumn).collect(Collectors.toSet());
        String conditionColumn = StringUtils.emptyToDefault(queryDefinition.getConditionColumn(), repository.getPrimaryKeyProperty());
        conditionColumn = repository.resolveToColumn(conditionColumn);
        return this.createMethodInvoker(annotation, repository, selectColumns, conditionColumn);
    }

    protected abstract @NonNull MethodInvoker createMethodInvoker(OrmAssembleAnnotation<A> var1, QueryRepository<R> var2, @Nullable Set<String> var3, String var4);

    public abstract R registerRepository(String var1, @NonNull R var2);

    protected synchronized QueryRepository<R> getRepository(OrmAssembleAnnotation<A> standardAnnotation) {
        QueryDefinition queryDefinition = standardAnnotation.getQueryDefinition();
        String repositoryId = queryDefinition.getRepositoryId();
        QueryRepository<R> result = this.ormRepositoryMap.get(repositoryId);
        if (Objects.nonNull(result) || Objects.isNull(this.repositoryTargetProvider)) {
            return result;
        }
        R target = this.repositoryTargetProvider.get(queryDefinition);
        if (Objects.nonNull(target)) {
            this.registerRepository(repositoryId, target);
        }
        return this.ormRepositoryMap.get(repositoryId);
    }

    @Override
    protected String determineNamespace(AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<A> standardAnnotation) {
        OrmAssembleAnnotation annotation = (OrmAssembleAnnotation)standardAnnotation;
        QueryDefinition queryDefinition = annotation.getQueryDefinition();
        String defInfo = StringUtils.format(NAMESPACE_TEMPLATE, queryDefinition.getDatasource(), queryDefinition.getMappingType(), queryDefinition.getSelectColumns(), queryDefinition.getRepositoryId(), queryDefinition.getConditionColumn());
        return StringUtils.md5DigestAsHex(defInfo);
    }

    @Override
    protected abstract OrmAssembleAnnotation<A> getStandardAnnotation(BeanOperations var1, AnnotatedElement var2, A var3);

    public void setRepositoryTargetProvider(@Nullable RepositoryTargetProvider<R> repositoryTargetProvider) {
        this.repositoryTargetProvider = repositoryTargetProvider;
    }

    @FunctionalInterface
    public static interface RepositoryTargetProvider<R> {
        public R get(QueryDefinition var1);
    }

    protected static class OrmAssembleAnnotation<A extends Annotation>
    extends AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter<A>
    implements AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotation<A> {
        private final QueryDefinition queryDefinition;

        protected OrmAssembleAnnotation(OrmAssembleAnnotationBuilder<A, ?, ?> b) {
            super(b);
            this.queryDefinition = ((OrmAssembleAnnotationBuilder)b).queryDefinition;
        }

        public static <A extends Annotation> OrmAssembleAnnotationBuilder<A, ?, ?> builder() {
            return new OrmAssembleAnnotationBuilderImpl();
        }

        public QueryDefinition getQueryDefinition() {
            return this.queryDefinition;
        }

        private static final class OrmAssembleAnnotationBuilderImpl<A extends Annotation>
        extends OrmAssembleAnnotationBuilder<A, OrmAssembleAnnotation<A>, OrmAssembleAnnotationBuilderImpl<A>> {
            private OrmAssembleAnnotationBuilderImpl() {
            }

            @Override
            protected OrmAssembleAnnotationBuilderImpl<A> self() {
                return this;
            }

            @Override
            public OrmAssembleAnnotation<A> build() {
                return new OrmAssembleAnnotation(this);
            }
        }

        public static abstract class OrmAssembleAnnotationBuilder<A extends Annotation, C extends OrmAssembleAnnotation<A>, B extends OrmAssembleAnnotationBuilder<A, C, B>>
        extends AbstractStandardAssembleAnnotationHandler.StandardAssembleAnnotationAdapter.StandardAssembleAnnotationAdapterBuilder<A, C, B> {
            private QueryDefinition queryDefinition;

            public B queryDefinition(QueryDefinition queryDefinition) {
                this.queryDefinition = queryDefinition;
                return (B)this.self();
            }

            @Override
            protected abstract B self();

            @Override
            public abstract C build();

            @Override
            public String toString() {
                return "AbstractQueryAssembleAnnotationHandler.OrmAssembleAnnotation.OrmAssembleAnnotationBuilder(super=" + super.toString() + ", queryDefinition=" + this.queryDefinition + ")";
            }
        }
    }
}

