/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.application;

import cn.dev33.satoken.util.SaFoxUtil;

public interface SaGetValueInterface {
    public Object get(String var1);

    default public <T> T get(String key, T defaultValue) {
        return this.getValueByDefaultValue(this.get(key), defaultValue);
    }

    default public String getString(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    default public int getInt(String key) {
        return this.getValueByDefaultValue(this.get(key), 0);
    }

    default public long getLong(String key) {
        return this.getValueByDefaultValue(this.get(key), 0L);
    }

    default public double getDouble(String key) {
        return this.getValueByDefaultValue(this.get(key), 0.0);
    }

    default public float getFloat(String key) {
        return this.getValueByDefaultValue(this.get(key), Float.valueOf(0.0f)).floatValue();
    }

    default public <T> T getModel(String key, Class<T> cs) {
        return SaFoxUtil.getValueByType(this.get(key), cs);
    }

    default public <T> T getModel(String key, Class<T> cs, Object defaultValue) {
        Object value = this.get(key);
        if (this.valueIsNull(value)) {
            return (T)defaultValue;
        }
        return SaFoxUtil.getValueByType(value, cs);
    }

    default public boolean has(String key) {
        return !this.valueIsNull(this.get(key));
    }

    default public boolean valueIsNull(Object value) {
        return value == null || value.equals("");
    }

    default public <T> T getValueByDefaultValue(Object value, T defaultValue) {
        if (this.valueIsNull(value)) {
            return defaultValue;
        }
        Class<?> cs = defaultValue.getClass();
        return (T)SaFoxUtil.getValueByType(value, cs);
    }
}

