/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.filter;

import cn.dev33.satoken.exception.RequestPathInvalidException;
import cn.dev33.satoken.strategy.SaStrategy;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.springframework.core.annotation.Order;

@Order(value=-1000)
public class SaPathCheckFilterForJakartaServlet
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            SaStrategy.instance.checkRequestPath.run(req.getRequestURI(), (Object)request, (Object)response);
        }
        catch (RequestPathInvalidException e) {
            if (SaStrategy.instance.requestPathInvalidHandle == null) {
                response.setContentType("text/plain; charset=utf-8");
                response.getWriter().print(e.getMessage());
                response.getWriter().flush();
            } else {
                SaStrategy.instance.requestPathInvalidHandle.run(e, (Object)request, (Object)response);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }
}

