/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso.message.handle.server;

import cn.dev33.satoken.sso.message.SaSsoMessage;
import cn.dev33.satoken.sso.message.handle.SaSsoMessageHandle;
import cn.dev33.satoken.sso.model.TicketModel;
import cn.dev33.satoken.sso.name.ParamName;
import cn.dev33.satoken.sso.template.SaSsoServerTemplate;
import cn.dev33.satoken.sso.template.SaSsoTemplate;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaResult;

public class SaSsoMessageCheckTicketHandle
implements SaSsoMessageHandle {
    @Override
    public String getHandlerType() {
        return "checkTicket";
    }

    @Override
    public Object handle(SaSsoTemplate ssoTemplate, SaSsoMessage message) {
        SaSsoServerTemplate ssoServerTemplate = (SaSsoServerTemplate)ssoTemplate;
        ParamName paramName = ssoServerTemplate.paramName;
        StpLogic stpLogic = ssoServerTemplate.getStpLogicOrGlobal();
        String client = message.getString(paramName.client);
        String ticket = message.getValueNotNull(paramName.ticket).toString();
        String sloCallback = message.getString(paramName.ssoLogoutCall);
        TicketModel ticketModel = ssoServerTemplate.checkTicketParamAndDelete(ticket, client);
        Object loginId = ticketModel.getLoginId();
        ssoServerTemplate.registerSloCallbackUrl(loginId, client, sloCallback);
        SaResult result = SaResult.ok();
        result.setData(loginId);
        result.set(paramName.loginId, loginId);
        result.set(paramName.tokenValue, (Object)ticketModel.getTokenValue());
        result.set(paramName.deviceId, (Object)stpLogic.getLoginDeviceIdByToken(ticketModel.getTokenValue()));
        result.set(paramName.remainTokenTimeout, (Object)stpLogic.getTokenTimeout(ticketModel.getTokenValue()));
        result.set(paramName.remainSessionTimeout, (Object)stpLogic.getSessionTimeoutByLoginId(loginId));
        result = (SaResult)ssoServerTemplate.strategy.checkTicketAppendData.apply(loginId, result);
        return result;
    }
}

