/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.temp.jwt;

import cn.dev33.satoken.exception.SaTokenException;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;

public class SaJwtUtil {
    public static final String KEY_VALUE = "value_";
    public static final String KEY_EFF = "eff";
    public static final long NEVER_EXPIRE = -1L;

    public static String createToken(String key, Object value, long timeout, String keyt) {
        long eff = timeout;
        if (timeout != -1L) {
            eff = timeout * 1000L + System.currentTimeMillis();
        }
        JwtBuilder builder = Jwts.builder().claim(KEY_VALUE + key, value).claim(KEY_EFF, (Object)eff).signWith(SignatureAlgorithm.HS256, keyt.getBytes());
        return builder.compact();
    }

    public static Claims parseToken(String jwtToken, String keyt) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(keyt.getBytes()).parseClaimsJws(jwtToken).getBody();
        return claims;
    }

    public static Object getValue(String key, String jwtToken, String keyt) {
        Claims claims = SaJwtUtil.parseToken(jwtToken, keyt);
        Long eff = (Long)claims.get(KEY_EFF, Long.class);
        if ((eff == null || eff < System.currentTimeMillis()) && eff != -1L) {
            throw new SaTokenException("Token\u5df2\u8d85\u65f6").setCode(30303);
        }
        return claims.get((Object)(KEY_VALUE + key));
    }

    public static long getTimeout(String key, String jwtToken, String keyt) {
        Claims claims = SaJwtUtil.parseToken(jwtToken, keyt);
        if (claims.get((Object)(KEY_VALUE + key)) == null) {
            return -2L;
        }
        Long eff = (Long)claims.get(KEY_EFF, Long.class);
        if (eff == -1L) {
            return -1L;
        }
        if (eff == null || eff < System.currentTimeMillis()) {
            return -2L;
        }
        return (eff - System.currentTimeMillis()) / 1000L;
    }
}

