/*
 * Decompiled with CFR 0.152.
 */
package cn.easyes.core.conditions;

import cn.easyes.annotation.rely.FieldType;
import cn.easyes.common.params.SFunction;
import cn.easyes.common.utils.ArrayUtils;
import cn.easyes.common.utils.StringUtils;
import cn.easyes.core.biz.EsIndexParam;
import cn.easyes.core.conditions.Wrapper;
import cn.easyes.core.conditions.interfaces.Index;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.common.settings.Settings;

public class LambdaEsIndexWrapper<T>
extends Wrapper<T>
implements Index<LambdaEsIndexWrapper<T>, SFunction<T, ?>> {
    protected String aliasName;
    protected Integer shardsNum;
    protected Integer replicasNum;
    protected Integer maxResultWindow;
    protected Map<String, Object> mapping;
    protected Settings settings;
    List<EsIndexParam> esIndexParamList;
    private final Class<T> entityClass;
    protected final LambdaEsIndexWrapper<T> typedThis = this;

    public LambdaEsIndexWrapper() {
        this(null);
    }

    public LambdaEsIndexWrapper(Class<T> entityClass) {
        this.entityClass = entityClass;
        this.esIndexParamList = new ArrayList<EsIndexParam>();
    }

    @Override
    protected SearchRequest getSearchRequest() {
        return null;
    }

    @Override
    public LambdaEsIndexWrapper<T> indexName(String ... indexNames) {
        if (ArrayUtils.isEmpty((Object[])indexNames)) {
            throw new RuntimeException("indexNames can not be empty");
        }
        this.indexNames = indexNames;
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> maxResultWindow(Integer maxResultWindow) {
        Optional.ofNullable(maxResultWindow).ifPresent(max -> {
            this.maxResultWindow = maxResultWindow;
        });
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> settings(Integer shards, Integer replicas) {
        if (Objects.nonNull(shards)) {
            this.shardsNum = shards;
        }
        if (Objects.nonNull(replicas)) {
            this.replicasNum = replicas;
        }
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> settings(Settings settings) {
        this.settings = settings;
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> mapping(Map<String, Object> mapping) {
        this.mapping = mapping;
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> mapping(String column, FieldType fieldType, String analyzer, String searchAnalyzer, String dateFormat, Boolean fieldData, Float boost) {
        this.addEsIndexParam(column, fieldType, analyzer, searchAnalyzer, dateFormat, fieldData, boost);
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> createAlias(String aliasName) {
        if (ArrayUtils.isEmpty((Object[])this.indexNames)) {
            throw new RuntimeException("indexNames can not be empty");
        }
        if (StringUtils.isEmpty((CharSequence)aliasName)) {
            throw new RuntimeException("aliasName can not be empty");
        }
        this.aliasName = aliasName;
        return this.typedThis;
    }

    @Override
    public LambdaEsIndexWrapper<T> join(String column, String parentName, String childName) {
        EsIndexParam esIndexParam = new EsIndexParam();
        esIndexParam.setFieldName(column);
        esIndexParam.setParentName(parentName);
        esIndexParam.setChildName(childName);
        esIndexParam.setFieldType(FieldType.JOIN.getType());
        this.esIndexParamList.add(esIndexParam);
        return this.typedThis;
    }

    private void addEsIndexParam(String fieldName, FieldType fieldType, String analyzer, String searchAnalyzer, String dateFormat, Boolean fieldData, Float boost) {
        EsIndexParam esIndexParam = new EsIndexParam();
        esIndexParam.setFieldName(fieldName);
        esIndexParam.setFieldType(fieldType.getType());
        esIndexParam.setAnalyzer(analyzer);
        esIndexParam.setSearchAnalyzer(searchAnalyzer);
        esIndexParam.setDateFormat(dateFormat);
        esIndexParam.setFieldData(fieldData);
        esIndexParam.setBoost(boost);
        this.esIndexParamList.add(esIndexParam);
    }
}

