/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.corpay.miniapppay;

import cn.felord.enumeration.MiniApyBillType;
import java.time.LocalDate;

public class BillRequest {
    private final LocalDate billDate;
    private final String mchid;
    private final String tarType;
    private MiniApyBillType billType;

    BillRequest(LocalDate billDate, String mchid, String tarType, MiniApyBillType billType) {
        this.billDate = billDate;
        this.mchid = mchid;
        this.tarType = tarType;
        this.billType = billType;
    }

    public static BillRequest stream(LocalDate billDate, String mchid) {
        return new BillRequest(billDate, mchid, null, null);
    }

    public static BillRequest stream(LocalDate billDate, String mchid, MiniApyBillType billType) {
        return new BillRequest(billDate, mchid, null, billType);
    }

    public static BillRequest gzip(LocalDate billDate, String mchid) {
        return new BillRequest(billDate, mchid, "GZIP", null);
    }

    public static BillRequest gzip(LocalDate billDate, String mchid, MiniApyBillType billType) {
        return new BillRequest(billDate, mchid, "GZIP", billType);
    }

    public LocalDate getBillDate() {
        return this.billDate;
    }

    public String getMchid() {
        return this.mchid;
    }

    public String getTarType() {
        return this.tarType;
    }

    public MiniApyBillType getBillType() {
        return this.billType;
    }

    public void setBillType(MiniApyBillType billType) {
        this.billType = billType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BillRequest)) {
            return false;
        }
        BillRequest other = (BillRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDate this$billDate = this.getBillDate();
        LocalDate other$billDate = other.getBillDate();
        if (this$billDate == null ? other$billDate != null : !((Object)this$billDate).equals(other$billDate)) {
            return false;
        }
        String this$mchid = this.getMchid();
        String other$mchid = other.getMchid();
        if (this$mchid == null ? other$mchid != null : !this$mchid.equals(other$mchid)) {
            return false;
        }
        String this$tarType = this.getTarType();
        String other$tarType = other.getTarType();
        if (this$tarType == null ? other$tarType != null : !this$tarType.equals(other$tarType)) {
            return false;
        }
        MiniApyBillType this$billType = this.getBillType();
        MiniApyBillType other$billType = other.getBillType();
        return !(this$billType == null ? other$billType != null : !((Object)((Object)this$billType)).equals((Object)other$billType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BillRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $billDate = this.getBillDate();
        result = result * 59 + ($billDate == null ? 43 : ((Object)$billDate).hashCode());
        String $mchid = this.getMchid();
        result = result * 59 + ($mchid == null ? 43 : $mchid.hashCode());
        String $tarType = this.getTarType();
        result = result * 59 + ($tarType == null ? 43 : $tarType.hashCode());
        MiniApyBillType $billType = this.getBillType();
        result = result * 59 + ($billType == null ? 43 : ((Object)((Object)$billType)).hashCode());
        return result;
    }

    public String toString() {
        return "BillRequest(billDate=" + this.getBillDate() + ", mchid=" + this.getMchid() + ", tarType=" + this.getTarType() + ", billType=" + (Object)((Object)this.getBillType()) + ")";
    }
}

