/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.externalcontact;

import cn.felord.domain.externalcontact.Conclusions;
import cn.felord.domain.externalcontact.MiniProgramStyle;
import cn.felord.enumeration.ContactScene;
import cn.felord.enumeration.ContactType;
import cn.felord.enumeration.MultiStyle;
import cn.felord.enumeration.SingleStyle;
import java.time.Duration;
import java.util.Collections;
import java.util.Set;

public class ContactWayBody {
    private final ContactType type;
    private final ContactScene scene;
    private MiniProgramStyle style;
    private String remark;
    private boolean skipVerify = true;
    private String state;
    private String unionid;
    private Set<String> user;
    private Set<Integer> party;
    private boolean isTemp = false;
    private Duration expiresIn;
    private Duration chatExpiresIn;
    private boolean isExclusive = false;
    private Conclusions conclusions;

    ContactWayBody(ContactType type, ContactScene scene) {
        this.type = type;
        this.scene = scene;
    }

    ContactWayBody(ContactScene scene, String user) {
        this(ContactType.SINGLE, scene);
        this.user = Collections.singleton(user);
    }

    ContactWayBody(ContactScene scene) {
        this(ContactType.MULTI, scene);
    }

    ContactWayBody(ContactScene scene, Set<Integer> party) {
        this(scene);
        this.party = party;
    }

    ContactWayBody(ContactScene scene, Set<Integer> party, Set<String> user) {
        this(scene);
        this.party = party;
        this.user = user;
    }

    public static ContactWayBody sigleMiniProgramContact(SingleStyle style, String user) {
        ContactWayBody contactWayBody = new ContactWayBody(ContactScene.MINI_PROGRAM, user);
        contactWayBody.style = style;
        return contactWayBody;
    }

    public static ContactWayBody sigleQrContact(String user) {
        return new ContactWayBody(ContactScene.QR_CODE, user);
    }

    public static ContactWayBody multiMiniProgramContact(MultiStyle style) {
        ContactWayBody contactWayBody = new ContactWayBody(ContactScene.MINI_PROGRAM);
        contactWayBody.style = style;
        return contactWayBody;
    }

    public static ContactWayBody multiMiniProgramContact(MultiStyle style, Set<Integer> party) {
        ContactWayBody contactWayBody = new ContactWayBody(ContactScene.MINI_PROGRAM, party);
        contactWayBody.style = style;
        return contactWayBody;
    }

    public static ContactWayBody multiMiniProgramContact(MultiStyle style, Set<Integer> party, Set<String> user) {
        ContactWayBody contactWayBody = new ContactWayBody(ContactScene.MINI_PROGRAM, party, user);
        contactWayBody.style = style;
        return contactWayBody;
    }

    public static ContactWayBody multiQrContact() {
        return new ContactWayBody(ContactScene.QR_CODE);
    }

    public static ContactWayBody multiQrContact(Set<Integer> party) {
        return new ContactWayBody(ContactScene.QR_CODE, party);
    }

    public static ContactWayBody multiQrContact(Set<Integer> party, Set<String> user) {
        return new ContactWayBody(ContactScene.QR_CODE, party, user);
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setSkipVerify(Boolean skipVerify) {
        this.skipVerify = skipVerify;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setUnionid(String unionid) {
        this.unionid = unionid;
    }

    public void setIsTemp(Boolean isTemp) {
        this.isTemp = isTemp;
    }

    public void setExpiresIn(Duration expiresIn) {
        this.expiresIn = expiresIn;
    }

    public void setChatExpiresIn(Duration chatExpiresIn) {
        this.chatExpiresIn = chatExpiresIn;
    }

    public void setIsExclusive(Boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    public void setConclusions(Conclusions conclusions) {
        this.conclusions = conclusions;
    }

    public ContactType getType() {
        return this.type;
    }

    public ContactScene getScene() {
        return this.scene;
    }

    public MiniProgramStyle getStyle() {
        return this.style;
    }

    public String getRemark() {
        return this.remark;
    }

    public Boolean getSkipVerify() {
        return this.skipVerify;
    }

    public String getState() {
        return this.state;
    }

    public String getUnionid() {
        return this.unionid;
    }

    public Set<String> getUser() {
        return this.user;
    }

    public Set<Integer> getParty() {
        return this.party;
    }

    public Boolean getIsTemp() {
        return this.isTemp;
    }

    public Duration getExpiresIn() {
        return this.expiresIn;
    }

    public Duration getChatExpiresIn() {
        return this.chatExpiresIn;
    }

    public Boolean getIsExclusive() {
        return this.isExclusive;
    }

    public Conclusions getConclusions() {
        return this.conclusions;
    }

    public String toString() {
        return "ContactWayRequest{type=" + (Object)((Object)this.type) + ", scene=" + (Object)((Object)this.scene) + ", remark='" + this.remark + '\'' + ", skipVerify=" + this.skipVerify + ", state='" + this.state + '\'' + ", unionid='" + this.unionid + '\'' + ", user=" + this.user + ", party=" + this.party + ", isTemp=" + this.isTemp + ", expiresIn=" + this.expiresIn + ", chatExpiresIn=" + this.chatExpiresIn + ", isExclusive=" + this.isExclusive + ", conclusions=" + this.conclusions + '}';
    }
}

