/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.externalcontact;

import cn.felord.domain.externalcontact.ContentText;
import cn.felord.domain.externalcontact.ImageMomentAttachment;
import cn.felord.domain.externalcontact.LinkMomentAttachment;
import cn.felord.domain.externalcontact.MomentAttachment;
import cn.felord.domain.externalcontact.VideoMomentAttachment;
import cn.felord.domain.externalcontact.VisibleRange;
import java.util.Collections;
import java.util.Set;

public class MomentBody<T extends MomentAttachment> {
    private final VisibleRange visibleRange;
    private ContentText text;
    private Set<T> attachments;

    protected MomentBody(VisibleRange visibleRange) {
        this.visibleRange = visibleRange;
    }

    public static MomentBody<MomentAttachment> textMoment(ContentText text, VisibleRange visibleRange) {
        MomentBody<MomentAttachment> momentAttachmentMomentBody = new MomentBody<MomentAttachment>(visibleRange);
        momentAttachmentMomentBody.setText(text);
        return momentAttachmentMomentBody;
    }

    public static MomentBody<ImageMomentAttachment> imageMoment(Set<ImageMomentAttachment> attachments, VisibleRange visibleRange) {
        MomentBody<ImageMomentAttachment> imageMomentAttachmentMomentBody = new MomentBody<ImageMomentAttachment>(visibleRange);
        super.setAttachments(attachments);
        return imageMomentAttachmentMomentBody;
    }

    public static MomentBody<VideoMomentAttachment> videoMoment(VideoMomentAttachment attachment, VisibleRange visibleRange) {
        MomentBody<VideoMomentAttachment> videoMomentAttachmentMomentBody = new MomentBody<VideoMomentAttachment>(visibleRange);
        super.setAttachments(Collections.singleton(attachment));
        return videoMomentAttachmentMomentBody;
    }

    public static MomentBody<LinkMomentAttachment> linkMoment(LinkMomentAttachment attachment, VisibleRange visibleRange) {
        MomentBody<LinkMomentAttachment> linkMomentAttachmentMomentBody = new MomentBody<LinkMomentAttachment>(visibleRange);
        super.setAttachments(Collections.singleton(attachment));
        return linkMomentAttachmentMomentBody;
    }

    public void setText(ContentText text) {
        this.text = text;
    }

    private void setAttachments(Set<T> attachments) {
        this.attachments = attachments;
    }

    public VisibleRange getVisibleRange() {
        return this.visibleRange;
    }

    public ContentText getText() {
        return this.text;
    }

    public Set<T> getAttachments() {
        return this.attachments;
    }
}

