/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.domain.message;

import cn.felord.domain.externalcontact.ContentText;
import cn.felord.domain.message.AbstractMessageBody;
import cn.felord.enumeration.BoolEnum;

public class MarkdownMessageBody
extends AbstractMessageBody {
    private final ContentText markdown;

    protected MarkdownMessageBody(String touser, String toparty, String totag, BoolEnum enableDuplicateCheck, Integer duplicateCheckInterval, ContentText markdown) {
        super("markdown", touser, toparty, totag, null, enableDuplicateCheck, duplicateCheckInterval);
        this.markdown = markdown;
    }

    public ContentText getMarkdown() {
        return this.markdown;
    }

    public static class Builder {
        private final ContentText markdown;
        private String touser;
        private String toparty;
        private String totag;
        private BoolEnum enableDuplicateCheck;
        private Integer duplicateCheckInterval;

        protected Builder(ContentText markdown) {
            this.markdown = markdown;
        }

        public Builder touser(String touser) {
            this.touser = touser;
            return this;
        }

        public Builder toparty(String toparty) {
            this.toparty = toparty;
            return this;
        }

        public Builder totag(String totag) {
            this.totag = totag;
            return this;
        }

        public Builder enableDuplicateCheck(BoolEnum enableDuplicateCheck) {
            this.enableDuplicateCheck = enableDuplicateCheck;
            return this;
        }

        public Builder duplicateCheckInterval(Integer duplicateCheckInterval) {
            this.duplicateCheckInterval = duplicateCheckInterval;
            return this;
        }

        public MarkdownMessageBody build() {
            return new MarkdownMessageBody(this.touser, this.toparty, this.totag, this.enableDuplicateCheck, this.duplicateCheckInterval, this.markdown);
        }
    }
}

