/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Objects;

public enum ChatType {
    SINGLE("single"),
    GROUP("group");

    private final String type;

    private ChatType(String type) {
        this.type = type;
    }

    @JsonValue
    public String getType() {
        return this.type;
    }

    @JsonCreator
    public static ChatType deserialize(String type) {
        return Arrays.stream(ChatType.values()).filter(contactType -> Objects.equals(type, contactType.type)).findFirst().orElse(null);
    }
}

