/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.enumeration;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;

public enum PaymentType {
    IN_CHAT(0),
    SCAN_QRCODE(1),
    IN_LIVE_ROOM(2),
    PRODUCT_BROCHURE(3),
    TRANSFER(14),
    MINIPROGRAM(15);

    private final int type;

    private PaymentType(int type) {
        this.type = type;
    }

    @JsonValue
    public int getType() {
        return this.type;
    }

    @JsonCreator
    public static PaymentType deserialize(int type) {
        return Arrays.stream(PaymentType.values()).filter(paymentType -> paymentType.type == type).findFirst().orElse(null);
    }
}

