/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.json;

import cn.felord.domain.approval.AttendanceConfig;
import cn.felord.domain.approval.ContactConfig;
import cn.felord.domain.approval.CtrlProperty;
import cn.felord.domain.approval.DateConfig;
import cn.felord.domain.approval.DateRangeConfig;
import cn.felord.domain.approval.EmptyConfig;
import cn.felord.domain.approval.FormulaConfig;
import cn.felord.domain.approval.LocationConfig;
import cn.felord.domain.approval.RelatedApprovalConfig;
import cn.felord.domain.approval.SelectorConfig;
import cn.felord.domain.approval.TableConfig;
import cn.felord.domain.approval.TmpControl;
import cn.felord.domain.approval.VacationConfig;
import cn.felord.enumeration.ApprovalCtrlType;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TmpControlDeserializer
extends JsonDeserializer<TmpControl<?>> {
    private static final Map<ApprovalCtrlType, Class<?>> CONTROL_MAP = new HashMap();

    public TmpControl<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode treeNode = (JsonNode)p.getCodec().readTree(p);
        JsonNode property = treeNode.get("property");
        CtrlProperty ctrlProperty = this.readTreeAsValue(ctxt, property, CtrlProperty.class);
        ApprovalCtrlType control = ctrlProperty.getControl();
        JsonNode configNode = treeNode.get("config");
        Class<?> configClazz = CONTROL_MAP.get((Object)control);
        EmptyConfig config = configClazz != null ? this.readTreeAsValue(ctxt, configNode, configClazz) : new EmptyConfig();
        return new TmpControl<EmptyConfig>(ctrlProperty, config);
    }

    public <T> T readTreeAsValue(DeserializationContext context, JsonNode n, Class<T> targetType) throws IOException {
        if (n == null) {
            return null;
        }
        try (TreeTraversingParser p = this._treeAsTokens(context, n);){
            Object object = context.readValue((JsonParser)p, targetType);
            return (T)object;
        }
    }

    private TreeTraversingParser _treeAsTokens(DeserializationContext context, JsonNode n) throws IOException {
        ObjectCodec codec = context == null ? null : context.getParser().getCodec();
        TreeTraversingParser p = new TreeTraversingParser(n, codec);
        p.nextToken();
        return p;
    }

    static {
        CONTROL_MAP.put(ApprovalCtrlType.TEXT, EmptyConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.TEXTAREA, EmptyConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.NUMBER, EmptyConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.MONEY, EmptyConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.TIPS, EmptyConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.DATE, DateConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.SELECTOR, SelectorConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.CONTACT, ContactConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.TABLE, TableConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.ATTENDANCE, AttendanceConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.VACATION, VacationConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.LOCATION, LocationConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.RELATED_APPROVAL, RelatedApprovalConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.FORMULA, FormulaConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.PHONE_NUMBER, EmptyConfig.class);
        CONTROL_MAP.put(ApprovalCtrlType.DATE_RANGE, DateRangeConfig.class);
    }
}

