/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.WeComException;
import cn.felord.domain.WeComResponse;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class ResponseBodyCallAdapterFactory
extends CallAdapter.Factory {
    public static final ResponseBodyCallAdapterFactory INSTANCE = new ResponseBodyCallAdapterFactory();

    private ResponseBodyCallAdapterFactory() {
    }

    public CallAdapter<?, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        return new ResponseBodyCallAdapter(returnType);
    }

    static final class ResponseBodyCallAdapter<R>
    implements CallAdapter<R, R> {
        private final Type returnType;

        ResponseBodyCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public R adapt(Call<R> call) {
            Response response;
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw new WeComException(e.getMessage());
            }
            if (response.isSuccessful()) {
                WeComResponse weComResponse;
                Object body = response.body();
                if (body != null && WeComResponse.class.isAssignableFrom(body.getClass()) && (weComResponse = (WeComResponse)body).isError()) {
                    throw new WeComException(weComResponse.getErrcode(), weComResponse.getErrmsg());
                }
                return (R)body;
            }
            throw new WeComException(" response is not successful, " + response.message());
        }
    }
}

