/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.json.JsonConverterFactory;
import cn.felord.retrofit.ResponseBodyCallAdapterFactory;
import cn.felord.retrofit.SSLManager;
import cn.felord.retrofit.TokenApi;
import cn.felord.retrofit.TokenInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory;

public final class RetrofitFactory {
    private static final String BASE_URL = "https://qyapi.weixin.qq.com/cgi-bin/";
    private static final String BASE_PAY_URL = "https://api.mch.weixin.qq.com/mmpaymkttransfers/";
    public static final Retrofit RETROFIT_ = new Retrofit.Builder().baseUrl("https://qyapi.weixin.qq.com/cgi-bin/").client(RetrofitFactory.okHttpClient(HttpLoggingInterceptor.Level.NONE)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)ResponseBodyCallAdapterFactory.INSTANCE).addConverterFactory((Converter.Factory)JsonConverterFactory.create()).build();

    private RetrofitFactory() {
    }

    public static <T extends TokenApi> Retrofit create(T tokenApi, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        return new Retrofit.Builder().baseUrl(BASE_URL).client(RetrofitFactory.okHttpClient(tokenApi, connectionPool, level)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)ResponseBodyCallAdapterFactory.INSTANCE).addConverterFactory((Converter.Factory)JsonConverterFactory.create()).build();
    }

    public static Retrofit create(SSLManager sslManager, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        return new Retrofit.Builder().baseUrl(BASE_PAY_URL).client(RetrofitFactory.okHttpClient(sslManager, connectionPool, level)).addCallAdapterFactory((CallAdapter.Factory)RxJava3CallAdapterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)ResponseBodyCallAdapterFactory.INSTANCE).addConverterFactory((Converter.Factory)JsonConverterFactory.create()).build();
    }

    private static OkHttpClient okHttpClient(SSLManager sslManager, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(level);
        return new OkHttpClient.Builder().connectionPool(connectionPool).sslSocketFactory(sslManager.getSslSocketFactory(), sslManager.getTrustManager()).addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    }

    private static OkHttpClient okHttpClient(TokenApi tokenApi, ConnectionPool connectionPool, HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(level);
        return new OkHttpClient.Builder().connectionPool(connectionPool).addInterceptor((Interceptor)new TokenInterceptor(tokenApi)).addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    }

    private static OkHttpClient okHttpClient(HttpLoggingInterceptor.Level level) {
        HttpLoggingInterceptor httpLoggingInterceptor = new HttpLoggingInterceptor();
        httpLoggingInterceptor.level(level);
        return new OkHttpClient.Builder().addInterceptor((Interceptor)httpLoggingInterceptor).retryOnConnectionFailure(true).connectTimeout(20L, TimeUnit.SECONDS).readTimeout(20L, TimeUnit.SECONDS).writeTimeout(20L, TimeUnit.SECONDS).build();
    }
}

