/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SSLManager {
    private final X509TrustManager trustManager;
    private final SSLSocketFactory sslSocketFactory;

    public SSLManager(InputStream pkcs12InputStream, String pin) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, CertificateException, IOException {
        KeyStore store = KeyStore.getInstance("PKCS12");
        store.load(pkcs12InputStream, pin.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(store);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        SSLContext tlSv1 = SSLContext.getInstance("TLSv1");
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagers[0];
        tlSv1.init(null, new TrustManager[]{x509TrustManager}, null);
        this.trustManager = x509TrustManager;
        this.sslSocketFactory = tlSv1.getSocketFactory();
    }

    public SSLManager(KeyStore loadedKeyStore) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(loadedKeyStore);
        Object[] trustManagers = trustManagerFactory.getTrustManagers();
        if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
            throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
        }
        SSLContext tlSv1 = SSLContext.getInstance("TLSv1");
        X509TrustManager x509TrustManager = (X509TrustManager)trustManagers[0];
        tlSv1.init(null, new TrustManager[]{x509TrustManager}, null);
        this.trustManager = x509TrustManager;
        this.sslSocketFactory = tlSv1.getSocketFactory();
    }

    public SSLManager(X509TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext tlSv1 = SSLContext.getInstance("TLSv1");
        tlSv1.init(null, new TrustManager[]{trustManager}, null);
        this.trustManager = trustManager;
        this.sslSocketFactory = tlSv1.getSocketFactory();
    }

    @JsonCreator
    public SSLManager(@JsonProperty(value="trustManager") X509TrustManager trustManager, @JsonProperty(value="sslSocketFactory") SSLSocketFactory sslSocketFactory) {
        this.trustManager = trustManager;
        this.sslSocketFactory = sslSocketFactory;
    }

    public X509TrustManager getTrustManager() {
        return this.trustManager;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }
}

