/*
 * Decompiled with CFR 0.152.
 */
package cn.felord.retrofit;

import cn.felord.WeComException;
import cn.felord.domain.WeComResponse;
import cn.felord.json.JacksonObjectMapperFactory;
import cn.felord.retrofit.AccessTokenApi;
import cn.felord.retrofit.TokenApi;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class TokenInterceptor
implements Interceptor {
    public static final Integer INVALID_ACCESS_TOKEN = 42001;
    public static final ObjectMapper MAPPER = JacksonObjectMapperFactory.create();
    private static final MediaType JSON_UTF_8 = MediaType.parse((String)"application/json; charset=UTF-8");
    private static final MediaType JSON = MediaType.parse((String)"application/json");
    private final TokenApi tokenApi;
    private final String tokenParam;

    public TokenInterceptor(TokenApi tokenApi) {
        this.tokenApi = tokenApi;
        this.tokenParam = this.determineTokenParam(tokenApi.getClass());
    }

    @NotNull
    public final Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response = this.doRequest(chain);
        ResponseBody body = response.body();
        if (body != null) {
            WeComResponse weComResponse;
            MediaType mediaType = body.contentType();
            String json = body.string();
            if ((Objects.equals(JSON_UTF_8, mediaType) || Objects.equals(JSON, mediaType)) && Objects.equals(INVALID_ACCESS_TOKEN, (weComResponse = (WeComResponse)MAPPER.readValue(json, WeComResponse.class)).getErrcode())) {
                this.tokenApi.clearToken();
                return this.doRequest(chain);
            }
            Headers headers = response.headers();
            return response.newBuilder().headers(headers).body(ResponseBody.create((String)json, (MediaType)mediaType)).build();
        }
        return response;
    }

    private Response doRequest(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        HttpUrl oldHttpUrl = request.url();
        String tokenResponse = this.tokenApi.getToken();
        Request requestWithAccessToken = request.newBuilder().url(oldHttpUrl.newBuilder().addQueryParameter(this.tokenParam, tokenResponse).build()).build();
        return chain.proceed(requestWithAccessToken);
    }

    private String determineTokenParam(Class<? extends TokenApi> tokenApiClazz) {
        if (AccessTokenApi.class.isAssignableFrom(tokenApiClazz)) {
            return "access_token";
        }
        throw new WeComException("the api is not supported");
    }
}

