/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.executor.support;

import cn.hippo4j.common.executor.support.CustomBlockingQueue;
import cn.hippo4j.common.executor.support.ResizableCapacityLinkedBlockingQueue;
import cn.hippo4j.common.extension.support.ServiceLoaderRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Predicate;
import lombok.Generated;

public enum BlockingQueueTypeEnum {
    ARRAY_BLOCKING_QUEUE(1, "ArrayBlockingQueue"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new ArrayBlockingQueue(capacity);
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new ArrayBlockingQueue(1024);
        }
    }
    ,
    LINKED_BLOCKING_QUEUE(2, "LinkedBlockingQueue"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new LinkedBlockingQueue(capacity);
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new LinkedBlockingQueue();
        }
    }
    ,
    LINKED_BLOCKING_DEQUE(3, "LinkedBlockingDeque"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new LinkedBlockingDeque(capacity);
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new LinkedBlockingDeque();
        }
    }
    ,
    SYNCHRONOUS_QUEUE(4, "SynchronousQueue"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new SynchronousQueue();
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new SynchronousQueue();
        }
    }
    ,
    LINKED_TRANSFER_QUEUE(5, "LinkedTransferQueue"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new LinkedTransferQueue();
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new LinkedTransferQueue();
        }
    }
    ,
    PRIORITY_BLOCKING_QUEUE(6, "PriorityBlockingQueue"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new PriorityBlockingQueue(capacity);
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new PriorityBlockingQueue();
        }
    }
    ,
    RESIZABLE_LINKED_BLOCKING_QUEUE(9, "ResizableCapacityLinkedBlockingQueue"){

        @Override
        <T> BlockingQueue<T> of(Integer capacity) {
            return new ResizableCapacityLinkedBlockingQueue(capacity);
        }

        @Override
        <T> BlockingQueue<T> of() {
            return new ResizableCapacityLinkedBlockingQueue();
        }
    };

    private final Integer type;
    private final String name;
    private static final Map<Integer, BlockingQueueTypeEnum> TYPE_TO_ENUM_MAP;
    private static final Map<String, BlockingQueueTypeEnum> NAME_TO_ENUM_MAP;
    private static final int DEFAULT_CAPACITY = 1024;

    abstract <T> BlockingQueue<T> of(Integer var1);

    abstract <T> BlockingQueue<T> of();

    private BlockingQueueTypeEnum(int type, String name) {
        this.type = type;
        this.name = name;
    }

    private static <T> BlockingQueue<T> of(String blockingQueueName, Integer capacity) {
        BlockingQueueTypeEnum typeEnum = NAME_TO_ENUM_MAP.get(blockingQueueName);
        if (typeEnum == null) {
            return null;
        }
        return Objects.isNull(capacity) ? typeEnum.of() : typeEnum.of(capacity);
    }

    private static <T> BlockingQueue<T> of(int type, Integer capacity) {
        BlockingQueueTypeEnum typeEnum = TYPE_TO_ENUM_MAP.get(type);
        if (typeEnum == null) {
            return null;
        }
        return Objects.isNull(capacity) ? typeEnum.of() : typeEnum.of(capacity);
    }

    private static <T> BlockingQueue<T> customOrDefaultQueue(Integer capacity, Predicate<CustomBlockingQueue> predicate) {
        Collection<CustomBlockingQueue> customBlockingQueues = ServiceLoaderRegistry.getSingletonServiceInstances(CustomBlockingQueue.class);
        return customBlockingQueues.stream().filter(predicate).map(each -> each.generateBlockingQueue()).findFirst().orElseGet(() -> {
            Integer tempCapacity = capacity;
            if (capacity == null || capacity <= 0) {
                tempCapacity = 1024;
            }
            return new LinkedBlockingQueue(tempCapacity);
        });
    }

    public static <T> BlockingQueue<T> createBlockingQueue(String blockingQueueName, Integer capacity) {
        BlockingQueue<T> of = BlockingQueueTypeEnum.of(blockingQueueName, capacity);
        if (of != null) {
            return of;
        }
        return BlockingQueueTypeEnum.customOrDefaultQueue(capacity, customerQueue -> Objects.equals(customerQueue.getName(), blockingQueueName));
    }

    public static <T> BlockingQueue<T> createBlockingQueue(int type, Integer capacity) {
        BlockingQueue<T> of = BlockingQueueTypeEnum.of(type, capacity);
        if (of != null) {
            return of;
        }
        return BlockingQueueTypeEnum.customOrDefaultQueue(capacity, customeQueue -> Objects.equals(customeQueue.getType(), type));
    }

    public static String getBlockingQueueNameByType(int type) {
        return Optional.ofNullable(TYPE_TO_ENUM_MAP.get(type)).map(value -> value.getName()).orElse("");
    }

    public static BlockingQueueTypeEnum getBlockingQueueTypeEnumByName(String name) {
        return Optional.ofNullable(NAME_TO_ENUM_MAP.get(name)).orElse(LINKED_BLOCKING_QUEUE);
    }

    @Generated
    public Integer getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    static {
        BlockingQueueTypeEnum[] values = BlockingQueueTypeEnum.values();
        TYPE_TO_ENUM_MAP = new HashMap<Integer, BlockingQueueTypeEnum>(values.length);
        NAME_TO_ENUM_MAP = new HashMap<String, BlockingQueueTypeEnum>(values.length);
        for (BlockingQueueTypeEnum value : values) {
            TYPE_TO_ENUM_MAP.put(value.type, value);
            NAME_TO_ENUM_MAP.put(value.name, value);
        }
        ServiceLoaderRegistry.register(CustomBlockingQueue.class);
    }
}

