/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.model;

import java.util.Arrays;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebIpAndPortInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebIpAndPortInfo.class);
    protected static final String ALL = "*";
    protected static final String SPOT = "\\.";
    protected static final String COLON = ":";
    private String ip;
    private String port;
    private String[] ipSegment;

    public WebIpAndPortInfo(String ip, String port) {
        this.ip = ip;
        this.port = port;
        this.ipSegment = ip.split(SPOT);
    }

    public static WebIpAndPortInfo build(String node) {
        if (ALL.equals(node)) {
            return new WebIpAndPortInfo(ALL, ALL);
        }
        String[] ipPort = node.split(COLON);
        if (ipPort.length != 2) {
            log.error("The IP address format is error : {}", (Object)node);
            return null;
        }
        return new WebIpAndPortInfo(ipPort[0], ipPort[1]);
    }

    public boolean check(String[] appIpSegment, String port) {
        return this.checkPort(port) && this.checkIp(appIpSegment);
    }

    protected boolean checkIp(String[] appIpSegment) {
        if (ALL.equals(this.ip)) {
            return true;
        }
        boolean flag = true;
        for (int i = 0; i < this.ipSegment.length && flag; ++i) {
            String propIp = this.ipSegment[i];
            String appIp = appIpSegment[i];
            flag = this.contrastSegment(appIp, propIp);
        }
        return flag;
    }

    protected boolean checkPort(String port) {
        return this.contrastSegment(port, this.port);
    }

    protected boolean contrastSegment(String appIp, String propIp) {
        return ALL.equals(propIp) || appIp.equals(propIp);
    }

    @Generated
    public String getIp() {
        return this.ip;
    }

    @Generated
    public String getPort() {
        return this.port;
    }

    @Generated
    public String[] getIpSegment() {
        return this.ipSegment;
    }

    @Generated
    public void setIp(String ip) {
        this.ip = ip;
    }

    @Generated
    public void setPort(String port) {
        this.port = port;
    }

    @Generated
    public void setIpSegment(String[] ipSegment) {
        this.ipSegment = ipSegment;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebIpAndPortInfo)) {
            return false;
        }
        WebIpAndPortInfo other = (WebIpAndPortInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        return Arrays.deepEquals(this.getIpSegment(), other.getIpSegment());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebIpAndPortInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIpSegment());
        return result;
    }

    @Generated
    public String toString() {
        return "WebIpAndPortInfo(ip=" + this.getIp() + ", port=" + this.getPort() + ", ipSegment=" + Arrays.deepToString(this.getIpSegment()) + ")";
    }
}

