/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import cn.hippo4j.common.toolkit.ReflectUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.common.web.exception.IllegalException;
import com.github.dozermapper.core.DozerBeanMapperBuilder;
import com.github.dozermapper.core.Mapper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class BeanUtil {
    protected static Mapper BEAN_MAPPER_BUILDER = DozerBeanMapperBuilder.buildDefault();

    public static <T, S> T convert(S source, Class<T> clazz) {
        return Optional.ofNullable(source).map(each -> BEAN_MAPPER_BUILDER.map(each, clazz)).orElse(null);
    }

    public static <T, S> T convert(S source, T target) {
        Optional.ofNullable(source).ifPresent(each -> BEAN_MAPPER_BUILDER.map(each, target));
        return target;
    }

    public static <T, S> List<T> convert(List<S> sources, Class<T> clazz) {
        return Optional.ofNullable(sources).map(each -> {
            ArrayList targetList = new ArrayList(each.size());
            each.forEach(item -> targetList.add(BEAN_MAPPER_BUILDER.map(item, clazz)));
            return targetList;
        }).orElse(null);
    }

    public static <T, S> Set<T> convert(Set<S> sources, Class<T> clazz) {
        return Optional.ofNullable(sources).map(each -> {
            HashSet targetSize = new HashSet(each.size());
            each.forEach(item -> targetSize.add(BEAN_MAPPER_BUILDER.map(item, clazz)));
            return targetSize;
        }).orElse(null);
    }

    public static <T> T mapToBean(Map<String, Object> map, Class<T> clazz, boolean toCamelCase) {
        if (clazz == null) {
            return null;
        }
        try {
            T newInstance = clazz.newInstance();
            return BeanUtil.mapToBean(map, newInstance, toCamelCase);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalException("do not create instance for " + clazz.getName(), e);
        }
    }

    public static <T> T mapToBean(Map<String, Object> map, T bean, boolean toCamelCase) {
        if (bean == null) {
            return null;
        }
        if (map.isEmpty()) {
            return bean;
        }
        Class<?> clazz = bean.getClass();
        map.forEach((s, o) -> {
            String name = toCamelCase ? StringUtil.toCamelCase(s, '_') : s;
            Method method = BeanUtil.setter(clazz, name);
            if (method != null) {
                ReflectUtil.invoke(bean, method, o);
            }
        });
        return bean;
    }

    public static Method getter(Class<?> o, String propertiesName) {
        if (o == null) {
            return null;
        }
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(propertiesName, o);
            return descriptor.getReadMethod();
        }
        catch (IntrospectionException e) {
            throw new IllegalException("not find getter for" + propertiesName + "in" + o.getName(), e);
        }
    }

    public static Method setter(Class<?> o, String propertiesName) {
        if (o == null) {
            return null;
        }
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(propertiesName, o);
            return descriptor.getWriteMethod();
        }
        catch (IntrospectionException e) {
            throw new IllegalException("not find setter for" + propertiesName + "in" + o.getName(), e);
        }
    }

    @Generated
    private BeanUtil() {
    }
}

