/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import cn.hippo4j.common.web.exception.IllegalException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.ClassPathResource;

public class FileUtil {
    private static final int ERROR_CODE = -1;

    public static String readUtf8String(String path) {
        String resultReadStr;
        ClassPathResource classPathResource = new ClassPathResource(path);
        try (InputStream inputStream = classPathResource.getInputStream();
             BufferedInputStream bis = new BufferedInputStream(inputStream);
             ByteArrayOutputStream buf = new ByteArrayOutputStream();){
            int result = bis.read();
            while (result != -1) {
                buf.write((byte)result);
                result = bis.read();
            }
            resultReadStr = buf.toString("UTF-8");
        }
        return resultReadStr;
    }

    public static List<String> readLines(String path, Charset charset) {
        ArrayList<String> strList = new ArrayList<String>();
        ClassPathResource classPathResource = new ClassPathResource(path);
        try (InputStreamReader in = new InputStreamReader(classPathResource.getInputStream(), charset);
             BufferedReader reader = new BufferedReader(in);){
            String line;
            while ((line = reader.readLine()) != null) {
                strList.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalException("file read error", e);
        }
        return strList;
    }
}

