/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public final class Joiner {
    private final String separator;

    private Joiner(String separator) {
        this.separator = Objects.requireNonNull(separator);
    }

    public static Joiner on(String separator) {
        return new Joiner(separator);
    }

    public String join(Object[] parts) {
        return this.join(Arrays.asList(parts));
    }

    public String join(Iterable<?> parts) {
        return this.join(parts.iterator());
    }

    public String join(Iterator<?> parts) {
        return this.appendTo((Appendable)new StringBuilder(), parts).toString();
    }

    public StringBuilder appendTo(StringBuilder builder, Iterator<?> parts) {
        try {
            this.appendTo((Appendable)builder, parts);
        }
        catch (IOException impossible) {
            throw new AssertionError((Object)impossible);
        }
        return builder;
    }

    public <A extends Appendable> A appendTo(A appendable, Iterator<?> parts) throws IOException {
        Objects.requireNonNull(appendable);
        if (parts.hasNext()) {
            appendable.append(this.toString(parts.next()));
            while (parts.hasNext()) {
                appendable.append(this.separator);
                appendable.append(this.toString(parts.next()));
            }
        }
        return appendable;
    }

    CharSequence toString(Object part) {
        Objects.requireNonNull(part);
        return part instanceof CharSequence ? (CharSequence)part : part.toString();
    }
}

