/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.web.base;

import cn.hippo4j.common.web.base.Result;
import cn.hippo4j.common.web.exception.AbstractException;
import cn.hippo4j.common.web.exception.ErrorCode;
import cn.hippo4j.common.web.exception.ErrorCodeEnum;
import java.util.Optional;

public final class Results {
    public static Result<Void> success() {
        return new Result().setCode("0");
    }

    public static <T> Result<T> success(T data) {
        return new Result().setCode("0").setData(data);
    }

    public static Result<Void> failure() {
        return Results.failure(ErrorCodeEnum.SERVICE_ERROR.getCode(), ErrorCodeEnum.SERVICE_ERROR.getMessage());
    }

    public static Result<Void> failure(AbstractException abstractException) {
        String errorCode = Optional.ofNullable(abstractException.getErrorCode()).map(ErrorCode::getCode).orElse(ErrorCodeEnum.SERVICE_ERROR.getCode());
        return new Result().setCode(errorCode).setMessage(abstractException.getMessage());
    }

    public static Result<Void> failure(Throwable throwable) {
        return new Result().setCode(ErrorCodeEnum.SERVICE_ERROR.getCode()).setMessage(throwable.getMessage());
    }

    public static Result<Void> failure(ErrorCode errorCode) {
        return Results.failure(errorCode.getCode(), errorCode.getMessage());
    }

    public static Result<Void> failure(String code, String message) {
        return new Result().setCode(code).setMessage(message);
    }
}

