/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cron.pattern;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.cron.pattern.CronPattern;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class CronPatternUtil {
    public static List<Date> matchedDates(String patternStr, Date start, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start, DateUtil.endOfYear(start), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, Date start, Date end, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(patternStr, start.getTime(), end.getTime(), count, isMatchSecond);
    }

    public static List<Date> matchedDates(String patternStr, long start, long end, int count, boolean isMatchSecond) {
        return CronPatternUtil.matchedDates(new CronPattern(patternStr), start, end, count, isMatchSecond);
    }

    public static List<Date> matchedDates(CronPattern pattern, long start, long end, int count, boolean isMatchSecond) {
        Assert.isTrue(start < end, "Start date is later than end !", new Object[0]);
        ArrayList<Date> result = new ArrayList<Date>(count);
        long step = isMatchSecond ? DateUnit.SECOND.getMillis() : DateUnit.MINUTE.getMillis();
        for (long i = start; i < end; i += step) {
            if (!pattern.match(i, isMatchSecond)) continue;
            result.add(DateUtil.date(i));
            if (result.size() >= count) break;
        }
        return result;
    }
}

