/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.io.file;

import cn.hutool.core.date.DateUnit;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.LineHandler;
import cn.hutool.core.io.file.FileMode;
import cn.hutool.core.io.file.LineReadWatcher;
import cn.hutool.core.lang.Console;
import cn.hutool.core.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class Tailer {
    public static final LineHandler CONSOLE_HANDLER = new ConsoleLineHandler();
    private Charset charset;
    private LineHandler lineHandler;
    private int initReadLine;
    private long period;
    private RandomAccessFile randomAccessFile;
    private ScheduledExecutorService executorService;

    public Tailer(File file, LineHandler lineHandler) {
        this(file, lineHandler, 0);
    }

    public Tailer(File file, LineHandler lineHandler, int initReadLine) {
        this(file, CharsetUtil.CHARSET_UTF_8, lineHandler, initReadLine, DateUnit.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, LineHandler lineHandler) {
        this(file, charset, lineHandler, 0, DateUnit.SECOND.getMillis());
    }

    public Tailer(File file, Charset charset, LineHandler lineHandler, int initReadLine, long period) {
        Tailer.checkFile(file);
        this.charset = charset;
        this.lineHandler = lineHandler;
        this.period = period;
        this.initReadLine = initReadLine;
        this.randomAccessFile = FileUtil.createRandomAccessFile(file, FileMode.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean async) {
        try {
            this.readTail();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        LineReadWatcher lineReadWatcher = new LineReadWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineReadWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (!async) {
            try {
                scheduledFuture.get();
            }
            catch (ExecutionException e) {
                throw new UtilException(e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    private void readTail() throws IOException {
        long len = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            long start = this.randomAccessFile.getFilePointer();
            long nextEnd = len - 1L;
            this.randomAccessFile.seek(nextEnd);
            int currentLine = 0;
            while (nextEnd > start && currentLine <= this.initReadLine) {
                int c = this.randomAccessFile.read();
                if (c == 10 || c == 13) {
                    FileUtil.readLine(this.randomAccessFile, this.charset, this.lineHandler);
                    ++currentLine;
                    --nextEnd;
                }
                this.randomAccessFile.seek(--nextEnd);
                if (nextEnd != 0L) continue;
                FileUtil.readLine(this.randomAccessFile, this.charset, this.lineHandler);
                break;
            }
        }
        try {
            this.randomAccessFile.seek(len);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new UtilException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new UtilException("Path [{}] is not a file !", file.getAbsolutePath());
        }
    }

    public static class ConsoleLineHandler
    implements LineHandler {
        @Override
        public void handle(String line) {
            Console.log(line);
        }
    }
}

