/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.captcha.generator;

import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -5514819971774091076L;
    private static final String operators = "+-*";
    private int numberLength;

    public MathGenerator() {
        this(2);
    }

    public MathGenerator(int numberLength) {
        this.numberLength = numberLength;
    }

    @Override
    public String generate() {
        String code = StrUtil.builder().append(StrUtil.padAfter((CharSequence)Integer.toString(RandomUtil.randomInt(this.getLimit())), this.numberLength, ' ')).append(RandomUtil.randomChar(operators)).append(StrUtil.padAfter((CharSequence)Integer.toString(RandomUtil.randomInt(this.getLimit())), this.numberLength, ' ')).toString();
        return code;
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int a = Integer.parseInt(StrUtil.sub(code, 0, this.numberLength).trim());
        char operator = code.charAt(this.numberLength);
        int b = Integer.parseInt(StrUtil.sub(code, this.numberLength + 1, this.numberLength + 1 + this.numberLength).trim());
        switch (operator) {
            case '+': {
                return a + b == result;
            }
            case '-': {
                return a - b == result;
            }
            case '*': {
                return a * b == result;
            }
        }
        return false;
    }

    @Override
    public int getLength() {
        return this.numberLength * 2 + 1;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StrUtil.repeat('0', this.numberLength));
    }
}

