/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.convert.ConvertException;
import cn.hutool.core.getter.OptNullBasicTypeFromObjectGetter;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONNull;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;

public interface JSONGetter<K>
extends OptNullBasicTypeFromObjectGetter<K> {
    default public boolean isNull(K key) {
        return JSONNull.NULL.equals(this.getObj(key));
    }

    default public String getStrEscaped(K key) {
        return this.getStrEscaped(key, null);
    }

    default public String getStrEscaped(K key, String defaultValue) {
        return JSONUtil.escape(this.getStr(key, defaultValue));
    }

    default public JSONArray getJSONArray(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        return new JSONArray(object);
    }

    default public JSONObject getJSONObject(K key) {
        Object object = this.getObj(key);
        if (null == object) {
            return null;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        return new JSONObject(object);
    }

    default public <T> T getBean(K key, Class<T> beanType) {
        JSONObject obj = this.getJSONObject(key);
        return null == obj ? null : (T)obj.toBean(beanType);
    }

    default public <T> T get(K key, Class<T> type) throws ConvertException {
        return this.get(key, type, false);
    }

    default public <T> T get(K key, Class<T> type, boolean ignoreError) throws ConvertException {
        Object value = this.getObj(key);
        if (null == value) {
            return null;
        }
        return JSONConverter.jsonConvert(type, value, ignoreError);
    }
}

