/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ModifierUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class EnumConverter
extends AbstractConverter<Object> {
    private static final long serialVersionUID = 1L;
    private static final Map<Class<?>, Map<Class<?>, Method>> VALUE_OF_METHOD_CACHE = new ConcurrentHashMap();
    private Class enumClass;

    public EnumConverter(Class enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    protected Object convertInternal(Object value) {
        Enum enumValue = EnumConverter.tryConvertEnum(value, this.enumClass);
        if (null == enumValue && !(value instanceof String)) {
            enumValue = Enum.valueOf(this.enumClass, this.convertToStr(value));
        }
        return enumValue;
    }

    @Override
    public Class getTargetType() {
        return this.enumClass;
    }

    protected static Enum tryConvertEnum(Object value, Class enumClass) {
        Map<Class<?>, Method> valueOfMethods;
        Enum enumResult = null;
        if (value instanceof Integer) {
            enumResult = (Enum)EnumUtil.getEnumAt(enumClass, (Integer)value);
        } else if (value instanceof String) {
            try {
                enumResult = (Enum)Enum.valueOf(enumClass, (String)value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (null == enumResult && MapUtil.isNotEmpty(valueOfMethods = EnumConverter.getValueOfMethods(enumClass))) {
            Class<?> valueClass = value.getClass();
            for (Map.Entry<Class<?>, Method> entry : valueOfMethods.entrySet()) {
                if (!ClassUtil.isAssignable(entry.getKey(), valueClass)) continue;
                enumResult = (Enum)ReflectUtil.invokeStatic(entry.getValue(), value);
            }
        }
        return enumResult;
    }

    private static Map<Class<?>, Method> getValueOfMethods(Class<?> enumClass) {
        Map<Class<?>, Method> valueOfMethods = VALUE_OF_METHOD_CACHE.get(enumClass);
        if (null == valueOfMethods) {
            valueOfMethods = Arrays.stream(enumClass.getMethods()).filter(ModifierUtil::isStatic).filter(m -> m.getReturnType() == enumClass).filter(m -> m.getParameterCount() == 1).filter(m -> false == "valueOf".equals(m.getName())).collect(Collectors.toMap(m -> m.getParameterTypes()[0], m -> m, (existing, replacement) -> existing));
            VALUE_OF_METHOD_CACHE.put(enumClass, valueOfMethods);
        }
        return valueOfMethods;
    }
}

