/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.date;

import cn.hutool.core.convert.NumberChineseFormatter;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.Zodiac;
import cn.hutool.core.date.chinese.ChineseMonth;
import cn.hutool.core.date.chinese.GanZhi;
import cn.hutool.core.date.chinese.LunarFestival;
import cn.hutool.core.date.chinese.LunarInfo;
import cn.hutool.core.util.StrUtil;
import java.util.Date;

public class ChineseDate {
    private final int year;
    private final int month;
    private final int day;
    private final int gyear;
    private final int gmonth;
    private final int gday;
    private boolean leap;

    public ChineseDate(Date date) {
        int iMonth;
        int iYear;
        int daysOfYear;
        int offset = (int)(DateUtil.beginOfDay(date).getTime() / DateUnit.DAY.getMillis() - -25538L);
        for (iYear = 1900; iYear <= LunarInfo.MAX_YEAR && offset >= (daysOfYear = LunarInfo.yearDays(iYear)); offset -= daysOfYear, ++iYear) {
        }
        this.year = iYear;
        int leapMonth = LunarInfo.leapMonth(iYear);
        int daysOfMonth = 0;
        for (iMonth = 1; iMonth < 13 && offset > 0; ++iMonth) {
            if (leapMonth > 0 && iMonth == leapMonth + 1 && !this.leap) {
                --iMonth;
                this.leap = true;
                daysOfMonth = LunarInfo.leapDays(this.year);
            } else {
                daysOfMonth = LunarInfo.monthDays(this.year, iMonth);
            }
            offset -= daysOfMonth;
            if (!this.leap || iMonth != leapMonth + 1) continue;
            this.leap = false;
        }
        if (offset == 0 && leapMonth > 0 && iMonth == leapMonth + 1) {
            if (this.leap) {
                this.leap = false;
            } else {
                this.leap = true;
                --iMonth;
            }
        }
        if (offset < 0) {
            offset += daysOfMonth;
            --iMonth;
        }
        this.month = iMonth;
        this.day = offset + 1;
        DateTime dt = DateUtil.date(date);
        this.gyear = dt.year();
        this.gmonth = dt.month() + 1;
        this.gday = dt.dayOfMonth();
    }

    public ChineseDate(int chineseYear, int chineseMonth, int chineseDay) {
        this.day = chineseDay;
        this.month = chineseMonth;
        this.year = chineseYear;
        this.leap = DateUtil.isLeapYear(chineseYear);
        int leapMonth = LunarInfo.leapMonth(chineseYear);
        DateTime dateTime = this.lunar2solar(chineseYear, chineseMonth, chineseDay, chineseMonth == leapMonth);
        if (null != dateTime) {
            this.gday = dateTime.dayOfMonth();
            this.gmonth = dateTime.month() + 1;
            this.gyear = dateTime.year();
        } else {
            this.gday = -1;
            this.gmonth = -1;
            this.gyear = -1;
        }
    }

    public int getChineseYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public boolean isLeapMonth() {
        return ChineseMonth.isLeapMonth(this.year, this.month);
    }

    public String getChineseMonth() {
        return ChineseMonth.getChineseMonthName(this.isLeapMonth(), this.month, false);
    }

    public String getChineseMonthName() {
        return ChineseMonth.getChineseMonthName(this.isLeapMonth(), this.month, true);
    }

    public int getDay() {
        return this.day;
    }

    public String getChineseDay() {
        int n;
        String[] chineseTen = new String[]{"\u521d", "\u5341", "\u5eff", "\u5345"};
        int n2 = n = this.day % 10 == 0 ? 9 : this.day % 10 - 1;
        if (this.day > 30) {
            return "";
        }
        switch (this.day) {
            case 10: {
                return "\u521d\u5341";
            }
            case 20: {
                return "\u4e8c\u5341";
            }
            case 30: {
                return "\u4e09\u5341";
            }
        }
        return chineseTen[this.day / 10] + NumberChineseFormatter.format(n + 1, false);
    }

    public String getFestivals() {
        return StrUtil.join(",", LunarFestival.getFestivals(this.year, this.month, this.day));
    }

    public String getChineseZodiac() {
        return Zodiac.getChineseZodiac(this.year);
    }

    public String getCyclical() {
        return GanZhi.getGanzhiOfYear(this.year);
    }

    public String getCyclicalYMD() {
        if (this.gyear >= 1900 && this.gmonth > 0 && this.gday > 0) {
            return this.cyclicalm(this.gyear, this.gmonth, this.gday);
        }
        return null;
    }

    public String toStringNormal() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.day);
    }

    public String toString() {
        return String.format("%s%s\u5e74 %s%s", this.getCyclical(), this.getChineseZodiac(), this.getChineseMonthName(), this.getChineseDay());
    }

    private String cyclicalm(int year, int month, int day) {
        return StrUtil.format("{}\u5e74{}\u6708{}\u65e5", GanZhi.getGanzhiOfYear(this.year), GanZhi.getGanzhiOfMonth(year, month, day), GanZhi.getGanzhiOfDay(year, month, day));
    }

    private DateTime lunar2solar(int chineseYear, int chineseMonth, int chineseDay, boolean isLeapMonth) {
        int day;
        if (chineseYear == 2100 && chineseMonth == 12 && chineseDay > 1 || chineseYear == 1900 && chineseMonth == 1 && chineseDay < 31) {
            return null;
        }
        int _day = day = LunarInfo.monthDays(chineseYear, chineseMonth);
        if (isLeapMonth) {
            _day = LunarInfo.leapDays(chineseYear);
        }
        if (chineseYear < 1900 || chineseYear > 2100 || chineseDay > _day) {
            return null;
        }
        int offset = 0;
        for (int i = 1900; i < chineseYear; ++i) {
            offset += LunarInfo.yearDays(i);
        }
        boolean isAdd = false;
        for (int i = 1; i < chineseMonth; ++i) {
            int leap = LunarInfo.leapMonth(chineseYear);
            if (!isAdd && leap <= i && leap > 0) {
                offset += LunarInfo.leapDays(chineseYear);
                isAdd = true;
            }
            offset += LunarInfo.monthDays(chineseYear, i);
        }
        if (isLeapMonth) {
            offset += day;
        }
        return DateUtil.date((long)(offset + chineseDay - 31) * 86400000L - 2203804800000L);
    }
}

