/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang;

import cn.hutool.core.lang.func.VoidFunc0;
import cn.hutool.core.util.StrUtil;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Opt<T> {
    private static final Opt<?> EMPTY = new Opt<Object>(null);
    private final T value;

    public static <T> Opt<T> empty() {
        Opt<?> t = EMPTY;
        return t;
    }

    public static <T> Opt<T> of(T value) {
        return new Opt<T>(Objects.requireNonNull(value));
    }

    public static <T> Opt<T> ofNullable(T value) {
        return value == null ? Opt.empty() : new Opt<T>(value);
    }

    public static <T> Opt<T> ofBlankAble(T value) {
        return StrUtil.isBlankIfStr(value) ? Opt.empty() : new Opt<T>(value);
    }

    private Opt(T value) {
        this.value = value;
    }

    public T get() {
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public void ifPresent(Consumer<? super T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public void ifPresentOrElse(Consumer<? super T> action, VoidFunc0 emptyAction) {
        if (this.value != null) {
            action.accept(this.value);
        } else {
            emptyAction.callWithRuntimeException();
        }
    }

    public Opt<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty()) {
            return this;
        }
        return predicate.test(this.value) ? this : Opt.empty();
    }

    public <U> Opt<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(mapper.apply(this.value));
    }

    public <U> Opt<U> flatMap(Function<? super T, ? extends Opt<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        Opt<? extends U> r = mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }

    public <U> Opt<U> flattedMap(Function<? super T, ? extends Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        return Opt.ofNullable(mapper.apply(this.value).orElse(null));
    }

    public Opt<T> peek(Consumer<T> action) throws NullPointerException {
        Objects.requireNonNull(action);
        if (this.isEmpty()) {
            return Opt.empty();
        }
        action.accept(this.value);
        return this;
    }

    @SafeVarargs
    public final Opt<T> peeks(Consumer<T> ... actions) throws NullPointerException {
        return Stream.of(actions).reduce(this, Opt::peek, (opts, opt) -> null);
    }

    public Opt<T> or(Supplier<? extends Opt<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Opt<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.value != null ? this.value : supplier.get();
    }

    public T orElseThrow() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public <X extends Throwable> T orElseThrow(Function<String, ? extends X> exceptionFunction, String message) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionFunction.apply(message);
    }

    public Optional<T> toOptional() {
        return Optional.ofNullable(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Opt)) {
            return false;
        }
        Opt other = (Opt)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? this.value.toString() : null;
    }
}

