/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;

public class NumberChineseFormatter {
    private static final char[] DIGITS = new char[]{'\u96f6', '\u4e00', '\u58f9', '\u4e8c', '\u8d30', '\u4e09', '\u53c1', '\u56db', '\u8086', '\u4e94', '\u4f0d', '\u516d', '\u9646', '\u4e03', '\u67d2', '\u516b', '\u634c', '\u4e5d', '\u7396'};
    private static final ChineseUnit[] CHINESE_NAME_VALUE = new ChineseUnit[]{new ChineseUnit(' ', 1, false), new ChineseUnit('\u5341', 10, false), new ChineseUnit('\u62fe', 10, false), new ChineseUnit('\u767e', 100, false), new ChineseUnit('\u4f70', 100, false), new ChineseUnit('\u5343', 1000, false), new ChineseUnit('\u4edf', 1000, false), new ChineseUnit('\u4e07', 10000, true), new ChineseUnit('\u4ebf', 100000000, true)};

    public static String format(double amount, boolean isUseTraditional) {
        return NumberChineseFormatter.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount = -amount;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        temp /= 10L;
        int[] parts = new int[20];
        int partsCount = 0;
        int i = 0;
        while (temp != 0L) {
            int part;
            parts[i] = part = (int)(temp % 10000L);
            ++partsCount;
            temp /= 10000L;
            ++i;
        }
        boolean underWanIsZero = true;
        StringBuilder chineseStr = new StringBuilder();
        for (int i2 = 0; i2 < partsCount; ++i2) {
            String partChinese = NumberChineseFormatter.toChinese(parts[i2], isUseTraditional);
            if (i2 % 2 == 0) {
                underWanIsZero = StrUtil.isEmpty(partChinese);
            }
            if (i2 != 0) {
                if (i2 % 2 == 0) {
                    if (parts[i2 - 1] < 1000) {
                        chineseStr.insert(0, "\u96f6");
                    }
                    chineseStr.insert(0, "\u4ebf");
                } else if (StrUtil.isEmpty(partChinese) && !underWanIsZero) {
                    chineseStr.insert(0, "\u96f6");
                } else {
                    if (parts[i2 - 1] < 1000 && parts[i2 - 1] > 0) {
                        chineseStr.insert(0, "\u96f6");
                    } else if (parts[i2] > 0 && parts[i2] % 10 == 0) {
                        chineseStr.insert(0, "\u96f6");
                    }
                    if (parts[i2] > 0) {
                        chineseStr.insert(0, "\u4e07");
                    }
                }
            }
            chineseStr.insert(0, partChinese);
        }
        if ("".equals(chineseStr.toString())) {
            chineseStr = new StringBuilder(String.valueOf(DIGITS[0]));
        }
        if (negative) {
            chineseStr.insert(0, "\u8d1f");
        }
        if (numFen != 0 || numJiao != 0) {
            if (numFen == 0) {
                chineseStr.append(isMoneyMode ? "\u5143" : "\u70b9").append(NumberChineseFormatter.numberToChinese(numJiao, isUseTraditional)).append(isMoneyMode ? "\u89d2" : "");
            } else if (numJiao == 0) {
                chineseStr.append(isMoneyMode ? "\u5143\u96f6" : "\u70b9\u96f6").append(NumberChineseFormatter.numberToChinese(numFen, isUseTraditional)).append(isMoneyMode ? "\u5206" : "");
            } else {
                chineseStr.append(isMoneyMode ? "\u5143" : "\u70b9").append(NumberChineseFormatter.numberToChinese(numJiao, isUseTraditional)).append(isMoneyMode ? "\u89d2" : "").append(NumberChineseFormatter.numberToChinese(numFen, isUseTraditional)).append(isMoneyMode ? "\u5206" : "");
            }
        } else if (isMoneyMode) {
            chineseStr.append("\u5143\u6574");
        }
        return chineseStr.toString();
    }

    public static String numberCharToChinese(char c, boolean isUseTraditional) {
        if (c < '0' || c > '9') {
            return String.valueOf(c);
        }
        return String.valueOf(NumberChineseFormatter.numberToChinese(c - 48, isUseTraditional));
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                chineseStr.insert(0, NumberChineseFormatter.numberToChinese(digit, isUseTraditional) + NumberChineseFormatter.getUnitName(i, isUseTraditional));
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }

    public static int chineseToNumber(String chinese) {
        int length = chinese.length();
        int result = 0;
        int section = 0;
        int number = 0;
        ChineseUnit unit = null;
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            int num = NumberChineseFormatter.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0 && null != unit) {
                        section += number * (unit.value / 10);
                    }
                    unit = null;
                } else if (number > 0) {
                    throw new IllegalArgumentException(StrUtil.format("Bad number '{}{}' at: {}", Character.valueOf(chinese.charAt(i - 1)), Character.valueOf(c), i));
                }
                number = num;
                continue;
            }
            unit = NumberChineseFormatter.chineseToUnit(c);
            if (null == unit) {
                throw new IllegalArgumentException(StrUtil.format("Unknown unit '{}' at: {}", Character.valueOf(c), i));
            }
            if (unit.secUnit) {
                section = (section + number) * unit.value;
                result += section;
                section = 0;
            } else {
                section += number * unit.value;
            }
            number = 0;
        }
        if (number > 0 && null != unit) {
            number *= unit.value / 10;
        }
        return result + section + number;
    }

    private static ChineseUnit chineseToUnit(char chinese) {
        for (ChineseUnit chineseNameValue : CHINESE_NAME_VALUE) {
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        int i;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        if ((i = ArrayUtil.indexOf(DIGITS, chinese)) > 0) {
            return (i + 1) / 2;
        }
        return i;
    }

    private static char numberToChinese(int number, boolean isUseTraditional) {
        if (0 == number) {
            return DIGITS[0];
        }
        return DIGITS[number * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return String.valueOf(CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)].name);
    }

    private static class ChineseUnit {
        private final char name;
        private final int value;
        private final boolean secUnit;

        public ChineseUnit(char name, int value, boolean secUnit) {
            this.name = name;
            this.value = value;
            this.secUnit = secUnit;
        }
    }
}

