/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.annotation;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.annotation.scanner.MetaAnnotationScanner;
import cn.hutool.core.lang.Opt;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SyntheticAnnotation<A extends Annotation>
implements Annotation,
AnnotatedElement {
    private final A source;
    private final Map<Class<? extends Annotation>, MetaAnnotation> metaAnnotationMap;
    private final Map<String, Map<Class<?>, Object>> attributeCaches;

    SyntheticAnnotation(A annotation) {
        this.source = annotation;
        this.metaAnnotationMap = new LinkedHashMap<Class<? extends Annotation>, MetaAnnotation>();
        this.attributeCaches = new HashMap();
        this.loadMetaAnnotations();
    }

    public static <T extends Annotation> SyntheticAnnotation<T> of(T rootAnnotation) {
        return new SyntheticAnnotation<T>(rootAnnotation);
    }

    public A getSource() {
        return this.source;
    }

    Map<Class<? extends Annotation>, MetaAnnotation> getMetaAnnotationMap() {
        return this.metaAnnotationMap;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return this.getSource().annotationType();
    }

    public Object getAttribute(String attributeName, Class<?> attributeType) {
        Map values = this.attributeCaches.computeIfAbsent(attributeName, t -> MapUtil.newHashMap());
        return values.computeIfAbsent(attributeType, a -> this.metaAnnotationMap.values().stream().filter(ma -> ma.hasAttribute(attributeName, attributeType)).findFirst().map(ma -> ma.getAttribute(attributeName)).orElse(null));
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        if (this.metaAnnotationMap.containsKey(annotationType)) {
            return (T)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType, Synthesized.class}, new SyntheticAnnotationProxy<T>(this, annotationType)));
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getMetaAnnotationMap().values().toArray(new MetaAnnotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[]{this.getSource()};
    }

    private void loadMetaAnnotations() {
        if (this.source instanceof Synthesized) {
            this.metaAnnotationMap.putAll(((Synthesized)this.source).getMetaAnnotationMap());
            return;
        }
        this.metaAnnotationMap.put(this.source.annotationType(), new MetaAnnotation((Annotation)this.source, 0));
        new MetaAnnotationScanner().scan((index, annotation) -> this.metaAnnotationMap.computeIfAbsent(annotation.annotationType(), t -> new MetaAnnotation((Annotation)annotation, (int)index)), this.source.annotationType(), null);
    }

    static class SyntheticAnnotationProxy<A extends Annotation>
    implements Annotation,
    InvocationHandler {
        private final Class<A> annotationType;
        private final SyntheticAnnotation<?> syntheticAnnotation;

        public SyntheticAnnotationProxy(SyntheticAnnotation<?> syntheticAnnotation, Class<A> annotationType) {
            this.syntheticAnnotation = syntheticAnnotation;
            this.annotationType = annotationType;
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.annotationType;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (Synthesized.isMetaAnnotationMapMethod(method)) {
                return this.syntheticAnnotation.getMetaAnnotationMap();
            }
            if (ReflectUtil.isHashCodeMethod(method)) {
                return this.getHashCode();
            }
            if (ReflectUtil.isToStringMethod(method)) {
                return this.getToString();
            }
            return ObjectUtil.defaultIfNull(this.syntheticAnnotation.getAttribute(method.getName(), method.getReturnType()), () -> ReflectUtil.invoke((Object)this, method, args));
        }

        private String getToString() {
            String attributes = Stream.of(this.annotationType().getDeclaredMethods()).filter(AnnotationUtil::isAttributeMethod).map(method -> StrUtil.format("{}={}", method.getName(), this.syntheticAnnotation.getAttribute(method.getName(), method.getReturnType()))).collect(Collectors.joining(", "));
            return StrUtil.format("@{}({})", this.annotationType().getName(), attributes);
        }

        private int getHashCode() {
            return Objects.hash(new Object[]{this.syntheticAnnotation.getAnnotations()});
        }
    }

    static interface Synthesized {
        public Map<Class<? extends Annotation>, MetaAnnotation> getMetaAnnotationMap();

        public static boolean isMetaAnnotationMapMethod(Method method) {
            return StrUtil.equals("getMetaAnnotationMap", method.getName());
        }
    }

    static class MetaAnnotation
    implements Annotation {
        private final Annotation annotation;
        private final Map<String, Method> attributeMethodCaches;
        private final int distance;

        public MetaAnnotation(Annotation annotation, int distance) {
            this.annotation = annotation;
            this.distance = distance;
            this.attributeMethodCaches = AnnotationUtil.getAttributeMethods(annotation.annotationType());
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.annotation.annotationType();
        }

        public Annotation get() {
            return this.annotation;
        }

        public int getDistance() {
            return this.distance;
        }

        public boolean hasAttribute(String attributeName) {
            return this.attributeMethodCaches.containsKey(attributeName);
        }

        public boolean hasAttribute(String attributeName, Class<?> returnType) {
            return Opt.ofNullable(this.attributeMethodCaches.get(attributeName)).filter(method -> ClassUtil.isAssignable(returnType, method.getReturnType())).isPresent();
        }

        public Object getAttribute(String attributeName) {
            return Opt.ofNullable(this.attributeMethodCaches.get(attributeName)).map(method -> ReflectUtil.invoke((Object)this.annotation, method, new Object[0])).orElse(null);
        }
    }
}

