/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.json;

import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.BeanCopier;
import cn.hutool.core.bean.copier.CopyOptions;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.CaseInsensitiveLinkedMap;
import cn.hutool.core.map.CaseInsensitiveMap;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.InternalJSONUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONConfig;
import cn.hutool.json.JSONConverter;
import cn.hutool.json.JSONException;
import cn.hutool.json.JSONGetter;
import cn.hutool.json.JSONTokener;
import cn.hutool.json.JSONUtil;
import cn.hutool.json.XML;
import cn.hutool.json.serialize.GlobalSerializeMapping;
import cn.hutool.json.serialize.JSONObjectSerializer;
import cn.hutool.json.serialize.JSONSerializer;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

public class JSONObject
implements JSON,
JSONGetter<String>,
Map<String, Object> {
    private static final long serialVersionUID = -330220388580734346L;
    public static final int DEFAULT_CAPACITY = 16;
    private final Map<String, Object> rawHashMap;
    private final JSONConfig config;

    public JSONObject() {
        this(16, false);
    }

    public JSONObject(boolean isOrder) {
        this(16, isOrder);
    }

    public JSONObject(int capacity, boolean isOrder) {
        this(capacity, false, isOrder);
    }

    public JSONObject(int capacity, boolean isIgnoreCase, boolean isOrder) {
        this(capacity, JSONConfig.create().setIgnoreCase(isIgnoreCase).setOrder(isOrder));
    }

    public JSONObject(JSONConfig config) {
        this(16, config);
    }

    public JSONObject(int capacity, JSONConfig config) {
        if (null == config) {
            config = JSONConfig.create();
        }
        this.rawHashMap = config.isIgnoreCase() ? (config.isOrder() ? new CaseInsensitiveLinkedMap(capacity) : new CaseInsensitiveMap(capacity)) : MapUtil.newHashMap((boolean)config.isOrder());
        this.config = config;
    }

    public JSONObject(Object source) {
        this(source, InternalJSONUtil.defaultIgnoreNullValue(source));
    }

    public JSONObject(Object source, boolean ignoreNullValue) {
        this(source, ignoreNullValue, source instanceof LinkedHashMap);
    }

    public JSONObject(Object source, boolean ignoreNullValue, boolean isOrder) {
        this(source, JSONConfig.create().setOrder(isOrder).setIgnoreCase(source instanceof CaseInsensitiveMap).setIgnoreNullValue(ignoreNullValue));
    }

    public JSONObject(Object source, JSONConfig config) {
        this(16, config);
        this.init(source);
    }

    public JSONObject(Object obj, String ... names) {
        this();
        if (ArrayUtil.isEmpty((Object[])names)) {
            this.init(obj);
            return;
        }
        if (obj instanceof Map) {
            for (String name : names) {
                Object value = ((Map)obj).get(name);
                this.putOnce(name, value);
            }
        } else {
            for (String name : names) {
                try {
                    this.putOpt(name, ReflectUtil.getFieldValue((Object)obj, (String)name));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public JSONObject(CharSequence source, boolean isOrder) throws JSONException {
        this((Object)source, JSONConfig.create().setOrder(isOrder));
    }

    @Override
    public JSONConfig getConfig() {
        return this.config;
    }

    public JSONObject setDateFormat(String format) {
        this.config.setDateFormat(format);
        return this;
    }

    public JSONArray toJSONArray(Collection<String> names) throws JSONException {
        if (CollectionUtil.isEmpty(names)) {
            return null;
        }
        JSONArray ja = new JSONArray(this.config);
        for (String name : names) {
            Object value = this.get(name);
            if (null == value) continue;
            ja.set(value);
        }
        return ja;
    }

    @Override
    public int size() {
        return this.rawHashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawHashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rawHashMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rawHashMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.rawHashMap.get(key);
    }

    public Object getObj(String key, Object defaultValue) {
        Object obj = this.rawHashMap.get(key);
        return null == obj ? defaultValue : obj;
    }

    @Override
    public Object getByPath(String expression) {
        return BeanPath.create((String)expression).get((Object)this);
    }

    @Override
    public <T> T getByPath(String expression, Class<T> resultType) {
        return JSONConverter.jsonConvert(resultType, this.getByPath(expression), true);
    }

    @Override
    public void putByPath(String expression, Object value) {
        BeanPath.create((String)expression).set((Object)this, value);
    }

    @Override
    @Deprecated
    public JSONObject put(String key, Object value) throws JSONException {
        return this.set(key, value);
    }

    public JSONObject set(String key, Object value) throws JSONException {
        if (null == key) {
            return this;
        }
        boolean ignoreNullValue = this.config.isIgnoreNullValue();
        if (ObjectUtil.isNull((Object)value) && ignoreNullValue) {
            this.remove(key);
        } else {
            InternalJSONUtil.testValidity(value);
            this.rawHashMap.put(key, JSONUtil.wrap(value, this.config));
        }
        return this;
    }

    public JSONObject putOnce(String key, Object value) throws JSONException {
        if (key != null) {
            if (this.rawHashMap.containsKey(key)) {
                throw new JSONException("Duplicate key \"{}\"", key);
            }
            this.set(key, value);
        }
        return this;
    }

    public JSONObject putOpt(String key, Object value) throws JSONException {
        if (key != null && value != null) {
            this.set(key, value);
        }
        return this;
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }

    public JSONObject accumulate(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, value);
        } else if (object instanceof JSONArray) {
            ((JSONArray)object).set(value);
        } else {
            this.set(key, JSONUtil.createArray(this.config).set(object).set(value));
        }
        return this;
    }

    public JSONObject append(String key, Object value) throws JSONException {
        InternalJSONUtil.testValidity(value);
        Object object = this.getObj(key);
        if (object == null) {
            this.set(key, new JSONArray(this.config).set(value));
        } else if (object instanceof JSONArray) {
            this.set(key, ((JSONArray)object).set(value));
        } else {
            throw new JSONException("JSONObject [" + key + "] is not a JSONArray.");
        }
        return this;
    }

    public JSONObject increment(String key) throws JSONException {
        Object value = this.getObj(key);
        if (value == null) {
            this.set(key, 1);
        } else if (value instanceof BigInteger) {
            this.set(key, ((BigInteger)value).add(BigInteger.ONE));
        } else if (value instanceof BigDecimal) {
            this.set(key, ((BigDecimal)value).add(BigDecimal.ONE));
        } else if (value instanceof Integer) {
            this.set(key, (Integer)value + 1);
        } else if (value instanceof Long) {
            this.set(key, (Long)value + 1L);
        } else if (value instanceof Double) {
            this.set(key, (Double)value + 1.0);
        } else if (value instanceof Float) {
            this.set(key, Float.valueOf(((Float)value).floatValue() + 1.0f));
        } else {
            throw new JSONException("Unable to increment [" + JSONUtil.quote(key) + "].");
        }
        return this;
    }

    @Override
    public Object remove(Object key) {
        return this.rawHashMap.remove(key);
    }

    @Override
    public void clear() {
        this.rawHashMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rawHashMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.rawHashMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.rawHashMap.entrySet();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rawHashMap == null ? 0 : this.rawHashMap.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        if (this.rawHashMap == null) {
            return other.rawHashMap == null;
        }
        return this.rawHashMap.equals(other.rawHashMap);
    }

    public String toString() {
        return this.toJSONString(0);
    }

    @Override
    public Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            return this.doWrite(writer, indentFactor, indent);
        }
        catch (IOException exception) {
            throw new JSONException(exception);
        }
    }

    private Writer doWrite(Writer writer, int indentFactor, int indent) throws IOException {
        writer.write(123);
        boolean isFirst = true;
        boolean isIgnoreNullValue = this.config.isIgnoreNullValue();
        int newIndent = indent + indentFactor;
        for (Map.Entry<String, Object> entry : this.entrySet()) {
            if (ObjectUtil.isNull((Object)entry.getKey()) || ObjectUtil.isNull((Object)entry.getValue()) && isIgnoreNullValue) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                writer.write(44);
            }
            if (indentFactor > 0) {
                writer.write(10);
            }
            InternalJSONUtil.indent(writer, newIndent);
            writer.write(JSONUtil.quote(entry.getKey()));
            writer.write(58);
            if (indentFactor > 0) {
                writer.write(32);
            }
            InternalJSONUtil.writeValue(writer, entry.getValue(), indentFactor, newIndent, this.config);
        }
        if (indentFactor > 0) {
            writer.write(10);
        }
        InternalJSONUtil.indent(writer, indent);
        writer.write(125);
        return writer;
    }

    private void populateMap(Object bean) {
        BeanCopier.create((Object)bean, (Object)this, (CopyOptions)CopyOptions.create().setIgnoreCase(this.config.isIgnoreCase()).setIgnoreError(true).setIgnoreNullValue(this.config.isIgnoreNullValue())).copy();
    }

    private void init(Object source) {
        if (null == source) {
            return;
        }
        JSONSerializer<JSON, ?> serializer = GlobalSerializeMapping.getSerializer(source.getClass());
        if (serializer instanceof JSONObjectSerializer) {
            serializer.serialize(this, source);
            return;
        }
        if (ArrayUtil.isArray((Object)source) || source instanceof Iterable || source instanceof Iterator) {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
        if (source instanceof Map) {
            for (Map.Entry e : ((Map)source).entrySet()) {
                this.set(Convert.toStr(e.getKey()), e.getValue());
            }
        } else if (source instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)source;
            this.set(Convert.toStr(entry.getKey()), entry.getValue());
        } else if (source instanceof CharSequence) {
            this.init((CharSequence)source);
        } else if (source instanceof JSONTokener) {
            this.init((JSONTokener)source);
        } else if (source instanceof ResourceBundle) {
            this.init((ResourceBundle)source);
        } else if (BeanUtil.isReadableBean(source.getClass())) {
            this.populateMap(source);
        } else {
            throw new JSONException("Unsupported type [{}] to JSONObject!", source.getClass());
        }
    }

    private void init(ResourceBundle bundle) {
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key == null) continue;
            InternalJSONUtil.propertyPut(this, key, bundle.getString(key));
        }
    }

    private void init(CharSequence source) {
        String jsonStr = StrUtil.trim((CharSequence)source);
        if (StrUtil.startWith((CharSequence)jsonStr, (char)'<')) {
            XML.toJSONObject(this, jsonStr, false);
        }
        this.init(new JSONTokener(StrUtil.trim((CharSequence)source), this.config));
    }

    private void init(JSONTokener x) {
        if (x.nextClean() != '{') {
            throw x.syntaxError("A JSONObject text must begin with '{'");
        }
        block8: while (true) {
            char c = x.nextClean();
            switch (c) {
                case '\u0000': {
                    throw x.syntaxError("A JSONObject text must end with '}'");
                }
                case '}': {
                    return;
                }
            }
            x.back();
            String key = x.nextValue().toString();
            c = x.nextClean();
            if (c != ':') {
                throw x.syntaxError("Expected a ':' after a key");
            }
            this.putOnce(key, x.nextValue());
            switch (x.nextClean()) {
                case ',': 
                case ';': {
                    if (x.nextClean() == '}') {
                        return;
                    }
                    x.back();
                    continue block8;
                }
                case '}': {
                    return;
                }
            }
            break;
        }
        throw x.syntaxError("Expected a ',' or '}'");
    }
}

