/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.system.oshi;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.system.oshi.CpuTicks;
import java.text.DecimalFormat;
import oshi.hardware.CentralProcessor;

public class CpuInfo {
    private static final DecimalFormat LOAD_FORMAT = new DecimalFormat("#.00");
    private Integer cpuNum;
    private double toTal;
    private double sys;
    private double user;
    private double wait;
    private double free;
    private String cpuModel;
    private CpuTicks ticks;

    public CpuInfo() {
    }

    public CpuInfo(CentralProcessor processor, long waitingTime) {
        this.init(processor, waitingTime);
    }

    public CpuInfo(Integer cpuNum, double toTal, double sys, double user, double wait, double free, String cpuModel) {
        this.cpuNum = cpuNum;
        this.toTal = toTal;
        this.sys = sys;
        this.user = user;
        this.wait = wait;
        this.free = free;
        this.cpuModel = cpuModel;
    }

    public Integer getCpuNum() {
        return this.cpuNum;
    }

    public void setCpuNum(Integer cpuNum) {
        this.cpuNum = cpuNum;
    }

    public double getToTal() {
        return this.toTal;
    }

    public void setToTal(double toTal) {
        this.toTal = toTal;
    }

    public double getSys() {
        return this.sys;
    }

    public void setSys(double sys) {
        this.sys = sys;
    }

    public double getUser() {
        return this.user;
    }

    public void setUser(double user) {
        this.user = user;
    }

    public double getWait() {
        return this.wait;
    }

    public void setWait(double wait) {
        this.wait = wait;
    }

    public double getFree() {
        return this.free;
    }

    public void setFree(double free) {
        this.free = free;
    }

    public String getCpuModel() {
        return this.cpuModel;
    }

    public void setCpuModel(String cpuModel) {
        this.cpuModel = cpuModel;
    }

    public CpuTicks getTicks() {
        return this.ticks;
    }

    public void setTicks(CpuTicks ticks) {
        this.ticks = ticks;
    }

    public double getUsed() {
        return NumberUtil.sub((float)100.0f, (double)this.free);
    }

    public String toString() {
        return "CpuInfo{CPU\u6838\u5fc3\u6570=" + this.cpuNum + ", CPU\u603b\u7684\u4f7f\u7528\u7387=" + this.toTal + ", CPU\u7cfb\u7edf\u4f7f\u7528\u7387=" + this.sys + ", CPU\u7528\u6237\u4f7f\u7528\u7387=" + this.user + ", CPU\u5f53\u524d\u7b49\u5f85\u7387=" + this.wait + ", CPU\u5f53\u524d\u7a7a\u95f2\u7387=" + this.free + ", CPU\u5229\u7528\u7387=" + this.getUsed() + ", CPU\u578b\u53f7\u4fe1\u606f='" + this.cpuModel + '\'' + '}';
    }

    private void init(CentralProcessor processor, long waitingTime) {
        CpuTicks ticks;
        this.ticks = ticks = new CpuTicks(processor, waitingTime);
        this.cpuNum = processor.getLogicalProcessorCount();
        this.cpuModel = processor.toString();
        long totalCpu = ticks.totalCpu();
        this.toTal = totalCpu;
        this.sys = CpuInfo.formatDouble(ticks.cSys, totalCpu);
        this.user = CpuInfo.formatDouble(ticks.user, totalCpu);
        this.wait = CpuInfo.formatDouble(ticks.ioWait, totalCpu);
        this.free = CpuInfo.formatDouble(ticks.idle, totalCpu);
    }

    private static double formatDouble(long tick, long totalCpu) {
        if (0L == totalCpu) {
            return 0.0;
        }
        return Double.parseDouble(LOAD_FORMAT.format(tick <= 0L ? 0.0 : 100.0 * (double)tick / (double)totalCpu));
    }
}

