/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.admin;

import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.DefaultResult;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.JPushConfig;
import cn.jpush.api.admin.AppResult;
import cn.jpush.api.admin.CreateAppResult;
import cn.jpush.api.file.FileClient;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminClient {
    protected static final Logger LOG = LoggerFactory.getLogger(FileClient.class);
    private IHttpClient mHttpClient;
    private String mBasePath;
    private String mV1AppPath;
    private Gson mGson = new Gson();

    public AdminClient(String appKey, String masterSecret) {
        this(appKey, masterSecret, null, JPushConfig.getInstance());
    }

    public AdminClient(String appKey, String masterSecret, HttpProxy proxy) {
        this(appKey, masterSecret, proxy, JPushConfig.getInstance());
    }

    public AdminClient(String appKey, String masterSecret, HttpProxy proxy, JPushConfig conf) {
        ServiceHelper.checkBasic((String)appKey, (String)masterSecret);
        this.mBasePath = (String)conf.get("api.admin.host.name");
        this.mV1AppPath = (String)conf.get("jpush.v1.app.path");
        String authCode = ServiceHelper.getBasicAuthorization((String)appKey, (String)masterSecret);
        this.mHttpClient = new NativeHttpClient(authCode, proxy, conf.getClientConfig());
    }

    public void setHttpClient(IHttpClient client) {
        this.mHttpClient = client;
    }

    public CreateAppResult createApp(String appName, String packageName, String groupName) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != appName ? 1 : 0) != 0, (Object)"app name should not be null");
        Preconditions.checkArgument((null != packageName ? 1 : 0) != 0, (Object)"package name should not be null");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("app_name", appName);
        jsonObject.addProperty("android_package", packageName);
        if (null != groupName) {
            jsonObject.addProperty("group_name", groupName);
        }
        ResponseWrapper responseWrapper = this.mHttpClient.sendPost(this.mBasePath + this.mV1AppPath, this.mGson.toJson((JsonElement)jsonObject));
        return (CreateAppResult)CreateAppResult.fromResponse((ResponseWrapper)responseWrapper, CreateAppResult.class);
    }

    public AppResult deleteApp(String appKey) throws APIConnectionException, APIRequestException {
        ResponseWrapper responseWrapper = this.mHttpClient.sendDelete(this.mBasePath + this.mV1AppPath + "/" + appKey + "/delete");
        return (AppResult)DefaultResult.fromResponse((ResponseWrapper)responseWrapper, AppResult.class);
    }

    public void uploadCertificate(String appKey, String devCertificateFile, String devCertificatePassword, String proCertificateFile, String proCertificatePassword) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((devCertificateFile != null || proCertificateFile != null ? 1 : 0) != 0, (Object)"dev certificate file or pro certificate file should not be null");
        NativeHttpClient client = (NativeHttpClient)this.mHttpClient;
        String url = this.mBasePath + this.mV1AppPath + "/" + appKey + "/certificate";
        HashMap<String, String> fileMap = new HashMap<String, String>();
        HashMap<String, String> textMap = new HashMap<String, String>();
        if (devCertificateFile != null) {
            textMap.put("devCertificatePassword", devCertificatePassword);
            fileMap.put("devCertificateFile", devCertificateFile);
        }
        if (proCertificateFile != null) {
            textMap.put("proCertificatePassword", proCertificatePassword);
            fileMap.put("proCertificateFile", proCertificateFile);
        }
        String response = client.formUploadByPost(url, textMap, fileMap, null);
        LOG.info("uploadFile:{}", (Object)response);
    }
}

