/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;

public class Notification3rd
implements PushModel {
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    private static final String CHANNEL_ID = "channel_id";
    private static final String URI_ACTIVITY = "uri_activity";
    private static final String URI_ACTION = "uri_action";
    private static final String BADGE_ADD_NUM = "badge_add_num";
    private static final String BADGE_SET_NUM = "badge_set_num";
    private static final String BADGE_CLASS = "badge_class";
    private static final String SOUND = "sound";
    private static final String EXTRAS = "extras";
    private final String title;
    private final String content;
    private final String channel_id;
    private final String uri_activity;
    private final String uri_action;
    private final int badge_add_num;
    private final int badge_set_num;
    private final String badge_class;
    private final String sound;
    private final Map<String, String> extras;
    private final Map<String, Number> numberExtras;
    private final Map<String, Boolean> booleanExtras;
    private final Map<String, JsonObject> jsonExtras;

    private Notification3rd(String title, String content, String channel_id, String uri_activity, String uri_action, int badge_add_num, int badge_set_num, String badge_class, String sound, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        this.title = title;
        this.content = content;
        this.channel_id = channel_id;
        this.uri_activity = uri_activity;
        this.uri_action = uri_action;
        this.badge_add_num = badge_add_num;
        this.badge_set_num = badge_set_num;
        this.badge_class = badge_class;
        this.sound = sound;
        this.extras = extras;
        this.numberExtras = numberExtras;
        this.booleanExtras = booleanExtras;
        this.jsonExtras = jsonExtras;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public JsonElement toJSON() {
        Object value;
        JsonObject json = new JsonObject();
        if (null != this.title) {
            json.addProperty(TITLE, this.title);
        }
        json.addProperty(CONTENT, this.content);
        if (null != this.channel_id) {
            json.addProperty(CHANNEL_ID, this.channel_id);
        }
        if (null != this.uri_activity) {
            json.addProperty(URI_ACTIVITY, this.uri_activity);
        }
        if (null != this.uri_action) {
            json.addProperty(URI_ACTION, this.uri_action);
        }
        if (0 != this.badge_add_num) {
            json.addProperty(BADGE_ADD_NUM, (Number)this.badge_add_num);
        }
        if (0 != this.badge_set_num) {
            json.addProperty(BADGE_SET_NUM, (Number)this.badge_set_num);
        }
        if (null != this.badge_class) {
            json.addProperty(BADGE_CLASS, this.badge_class);
        }
        if (null != this.sound) {
            json.addProperty(SOUND, this.sound);
        }
        JsonObject extrasObject = null;
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            extrasObject = new JsonObject();
        }
        if (null != this.extras) {
            value = null;
            for (String key : this.extras.keySet()) {
                value = this.extras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((String)value));
            }
        }
        if (null != this.numberExtras) {
            value = null;
            for (String key : this.numberExtras.keySet()) {
                value = this.numberExtras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Number)value));
            }
        }
        if (null != this.booleanExtras) {
            value = null;
            for (String key : this.booleanExtras.keySet()) {
                value = this.booleanExtras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Boolean)value));
            }
        }
        if (null != this.jsonExtras) {
            value = null;
            for (String key : this.jsonExtras.keySet()) {
                value = this.jsonExtras.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)value);
            }
        }
        if (null != this.extras || null != this.numberExtras || null != this.booleanExtras || null != this.jsonExtras) {
            json.add(EXTRAS, (JsonElement)extrasObject);
        }
        return json;
    }

    public static class Builder {
        private String title;
        private String content;
        private String channel_id;
        private String uri_activity;
        private String uri_action;
        private int badge_add_num;
        private int badge_set_num;
        private String badge_class;
        private String sound;
        protected Map<String, String> extrasBuilder;
        protected Map<String, Number> numberExtrasBuilder;
        protected Map<String, Boolean> booleanExtrasBuilder;
        protected Map<String, JsonObject> jsonExtrasBuilder;

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContent(String content) {
            this.content = content;
            return this;
        }

        public Builder setChannelId(String channel_id) {
            this.channel_id = channel_id;
            return this;
        }

        public Builder setUriActivity(String uri_activity) {
            this.uri_activity = uri_activity;
            return this;
        }

        public Builder setUriAction(String uri_action) {
            this.uri_action = uri_action;
            return this;
        }

        public Builder setBadgeAddNum(int badge_add_num) {
            this.badge_add_num = badge_add_num;
            return this;
        }

        public Builder setBadgeSetNum(int badge_set_num) {
            this.badge_set_num = badge_set_num;
            return this;
        }

        public Builder setBadgeClass(String badge_class) {
            this.badge_class = badge_class;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public Builder addExtra(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            this.extrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtras(Map<String, String> extras) {
            Preconditions.checkArgument((null != extras ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.extrasBuilder) {
                this.extrasBuilder = new HashMap<String, String>();
            }
            for (String key : extras.keySet()) {
                this.extrasBuilder.put(key, extras.get(key));
            }
            return this;
        }

        public Builder addExtra(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberExtrasBuilder) {
                this.numberExtrasBuilder = new HashMap<String, Number>();
            }
            this.numberExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanExtrasBuilder) {
                this.booleanExtrasBuilder = new HashMap<String, Boolean>();
            }
            this.booleanExtrasBuilder.put(key, value);
            return this;
        }

        public Builder addExtra(String key, JsonObject value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.jsonExtrasBuilder) {
                this.jsonExtrasBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonExtrasBuilder.put(key, value);
            return this;
        }

        public Notification3rd build() {
            Preconditions.checkArgument((this.content != null && this.content != "" ? 1 : 0) != 0, (Object)"content should not be null or empty");
            return new Notification3rd(this.title, this.content, this.channel_id, this.uri_activity, this.uri_action, this.badge_add_num, this.badge_set_num, this.badge_class, this.sound, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

