/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jiguang.common.utils.Preconditions;
import cn.jpush.api.push.model.PushModel;
import cn.jpush.api.push.model.notification.AndroidNotification;
import cn.jpush.api.push.model.notification.IosAlert;
import cn.jpush.api.push.model.notification.IosNotification;
import cn.jpush.api.push.model.notification.PlatformNotification;
import cn.jpush.api.push.model.notification.WinphoneNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Notification
implements PushModel {
    private static final String AI_OPPORTUNITY = "ai_opportunity";
    private static final String VOIP = "voip";
    private boolean aiOpportunity;
    private final Object alert;
    private final Set<PlatformNotification> notifications;
    private final Map<String, String> voip;
    private final Map<String, Number> numberVoip;
    private final Map<String, Boolean> booleanVoip;
    private final Map<String, JsonObject> jsonVoip;

    private Notification(boolean aiOpportunity, Object alert, Set<PlatformNotification> notifications, Map<String, String> voip, Map<String, Number> numberVoip, Map<String, Boolean> booleanVoip, Map<String, JsonObject> jsonVoip) {
        this.aiOpportunity = aiOpportunity;
        this.alert = alert;
        this.notifications = notifications;
        this.voip = voip;
        this.numberVoip = numberVoip;
        this.booleanVoip = booleanVoip;
        this.jsonVoip = jsonVoip;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Notification aiOpportunity(boolean ai_opportunity) {
        return Notification.newBuilder().setAiOpportunity(ai_opportunity).build();
    }

    public static Notification alert(Object alert) {
        return Notification.newBuilder().setAlert(alert).build();
    }

    public static Notification android(String alert, String title, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(((AndroidNotification.Builder)AndroidNotification.newBuilder().setAlert(alert).setTitle(title).addExtras(extras)).build()).build();
    }

    public static Notification ios(Object alert, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(((IosNotification.Builder)IosNotification.newBuilder().setAlert(alert).addExtras(extras)).build()).build();
    }

    public static Notification ios_auto_badge() {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert("").autoBadge().build()).build();
    }

    public static Notification ios_set_badge(int badge) {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert("").setBadge(badge).build()).build();
    }

    public static Notification ios_incr_badge(int badge) {
        return Notification.newBuilder().addPlatformNotification(IosNotification.newBuilder().setAlert("").incrBadge(badge).build()).build();
    }

    public static Notification winphone(String alert, Map<String, String> extras) {
        return Notification.newBuilder().addPlatformNotification(((WinphoneNotification.Builder)WinphoneNotification.newBuilder().setAlert(alert).addExtras(extras)).build()).build();
    }

    @Override
    public JsonElement toJSON() {
        Object value;
        JsonObject json = new JsonObject();
        json.addProperty(AI_OPPORTUNITY, Boolean.valueOf(this.aiOpportunity));
        if (null != this.alert) {
            if (this.alert instanceof JsonObject) {
                json.add("alert", (JsonElement)((JsonObject)this.alert));
            } else if (this.alert instanceof IosAlert) {
                json.add("alert", ((IosAlert)this.alert).toJSON());
            } else {
                json.add("alert", (JsonElement)new JsonPrimitive(this.alert.toString()));
            }
        }
        if (null != this.notifications) {
            for (PlatformNotification pn : this.notifications) {
                if (this.alert != null && pn.getAlert() == null) {
                    pn.setAlert(this.alert);
                }
                Preconditions.checkArgument((null != pn.getAlert() ? 1 : 0) != 0, (Object)"For any platform notification, alert field is needed. It can be empty string.");
                json.add(pn.getPlatform(), pn.toJSON());
            }
        }
        JsonObject extrasObject = null;
        if (null != this.voip || null != this.numberVoip || null != this.booleanVoip || null != this.jsonVoip) {
            extrasObject = new JsonObject();
        }
        if (null != this.voip) {
            value = null;
            for (String key : this.voip.keySet()) {
                value = this.voip.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((String)value));
            }
        }
        if (null != this.numberVoip) {
            value = null;
            for (String key : this.numberVoip.keySet()) {
                value = this.numberVoip.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Number)value));
            }
        }
        if (null != this.booleanVoip) {
            value = null;
            for (String key : this.booleanVoip.keySet()) {
                value = this.booleanVoip.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)new JsonPrimitive((Boolean)value));
            }
        }
        if (null != this.jsonVoip) {
            value = null;
            for (String key : this.jsonVoip.keySet()) {
                value = this.jsonVoip.get(key);
                if (null == value) continue;
                extrasObject.add(key, (JsonElement)value);
            }
        }
        if (null != this.voip || null != this.numberVoip || null != this.booleanVoip || null != this.jsonVoip) {
            json.add(VOIP, (JsonElement)extrasObject);
        }
        return json;
    }

    public static class Builder {
        private boolean aiOpportunity;
        private Object alert;
        private Set<PlatformNotification> builder;
        protected Map<String, String> voipBuilder;
        protected Map<String, Number> numberVoipBuilder;
        protected Map<String, Boolean> booleanVoipBuilder;
        protected Map<String, JsonObject> jsonVoipBuilder;

        public Builder setAiOpportunity(boolean aiOpportunity) {
            this.aiOpportunity = aiOpportunity;
            return this;
        }

        public Builder setAlert(Object alert) {
            this.alert = alert;
            return this;
        }

        public Builder addPlatformNotification(PlatformNotification notification) {
            if (null == this.builder) {
                this.builder = new HashSet<PlatformNotification>();
            }
            this.builder.add(notification);
            return this;
        }

        public Builder addVoip(String key, String value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.voipBuilder) {
                this.voipBuilder = new HashMap<String, String>();
            }
            this.voipBuilder.put(key, value);
            return this;
        }

        public Builder addVoip(Map<String, String> voip) {
            Preconditions.checkArgument((null != voip ? 1 : 0) != 0, (Object)"extras should not be null.");
            if (null == this.voipBuilder) {
                this.voipBuilder = new HashMap<String, String>();
            }
            for (String key : voip.keySet()) {
                this.voipBuilder.put(key, voip.get(key));
            }
            return this;
        }

        public Builder addVoip(String key, Number value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.numberVoipBuilder) {
                this.numberVoipBuilder = new HashMap<String, Number>();
            }
            this.numberVoipBuilder.put(key, value);
            return this;
        }

        public Builder addVoip(String key, Boolean value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.booleanVoipBuilder) {
                this.booleanVoipBuilder = new HashMap<String, Boolean>();
            }
            this.booleanVoipBuilder.put(key, value);
            return this;
        }

        public Builder addVoip(String key, JsonObject value) {
            Preconditions.checkArgument((null != key && null != value ? 1 : 0) != 0, (Object)"Key/Value should not be null.");
            if (null == this.jsonVoipBuilder) {
                this.jsonVoipBuilder = new HashMap<String, JsonObject>();
            }
            this.jsonVoipBuilder.put(key, value);
            return this;
        }

        public Notification build() {
            Preconditions.checkArgument((null != this.builder || null != this.alert ? 1 : 0) != 0, (Object)"No notification payload is set.");
            return new Notification(this.aiOpportunity, this.alert, this.builder, this.voipBuilder, this.numberVoipBuilder, this.booleanVoipBuilder, this.jsonVoipBuilder);
        }
    }
}

