/*
 * Decompiled with CFR 0.152.
 */
package io.rong;

import io.rong.CenterEnum;
import io.rong.RongCloudConfig;
import io.rong.methods.agent.AIAgent;
import io.rong.methods.chatbot.Chatbot;
import io.rong.methods.chatroom.Chatroom;
import io.rong.methods.conversation.Conversation;
import io.rong.methods.group.Group;
import io.rong.methods.message.Message;
import io.rong.methods.message.expansion.Expansion;
import io.rong.methods.profile.EntrustGroup;
import io.rong.methods.profile.EntrustUser;
import io.rong.methods.profile.Friend;
import io.rong.methods.push.Push;
import io.rong.methods.push.PushCustom;
import io.rong.methods.sensitive.SensitiveWord;
import io.rong.methods.sensitive.Wordfilter;
import io.rong.methods.ultragroup.UltraGroup;
import io.rong.methods.user.User;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class RongCloud {
    private static ConcurrentHashMap<String, RongCloud> rongCloud = new ConcurrentHashMap();
    public User user;
    public Message message;
    public Expansion expansion;
    public Wordfilter wordfilter;
    public SensitiveWord sensitiveword;
    public Group group;
    public UltraGroup ultraGroup;
    public Chatroom chatroom;
    public Conversation conversation;
    public Push push;
    public PushCustom pushCustom;
    public EntrustGroup entrustGroup;
    public Friend friend;
    public EntrustUser entrustUser;
    public Chatbot chatbot;
    public AIAgent agent;
    public final RongCloudConfig config;

    public RongCloudConfig getConfig() {
        return this.config;
    }

    private RongCloud(String appKey, String appSecret, RongCloudConfig config) {
        RongCloud.checkAppKeyAndAppSecret(appKey, appSecret);
        if (config == null) {
            throw new IllegalArgumentException("'config' can not be null");
        }
        if (StringUtils.isBlank((CharSequence)config.getDomain())) {
            throw new IllegalArgumentException("'config' must set domains");
        }
        this.user = new User(appKey, appSecret, this);
        this.message = new Message(appKey, appSecret);
        this.message.setRongCloud(this);
        this.expansion = new Expansion(appKey, appSecret);
        this.expansion.setRongCloud(this);
        this.wordfilter = new Wordfilter(appKey, appSecret);
        this.wordfilter.setRongCloud(this);
        this.sensitiveword = new SensitiveWord(appKey, appSecret);
        this.sensitiveword.setRongCloud(this);
        this.group = new Group(appKey, appSecret, this);
        this.ultraGroup = new UltraGroup(appKey, appSecret, this);
        this.chatroom = new Chatroom(appKey, appSecret, this);
        this.chatroom.setRongCloud(this);
        this.conversation = new Conversation(appKey, appSecret);
        this.conversation.setRongCloud(this);
        this.push = new Push(appKey, appSecret);
        this.push.setRongCloud(this);
        this.pushCustom = new PushCustom(appKey, appSecret, this);
        this.entrustGroup = new EntrustGroup(appKey, appSecret, this);
        this.friend = new Friend(appKey, appSecret, this);
        this.entrustUser = new EntrustUser(appKey, appSecret, this);
        this.chatbot = new Chatbot(appKey, appSecret, this);
        this.agent = new AIAgent(appKey, appSecret, this);
        this.config = config;
    }

    public static RongCloud getInstance(String appKey, String appSecret, CenterEnum centerEnum) {
        RongCloud.checkAppKeyAndAppSecret(appKey, appSecret);
        if (centerEnum == null) {
            throw new IllegalArgumentException("'centerEnum' can not be null");
        }
        return RongCloud.getInstance(appKey, appSecret, new RongCloudConfig(centerEnum.getPrimaryUrl(), centerEnum.getBackupUrl()));
    }

    public static RongCloud getInstance(String appKey, String appSecret, RongCloudConfig config) {
        RongCloud.checkAppKeyAndAppSecret(appKey, appSecret);
        if (null == rongCloud.get(appKey + "_" + appSecret)) {
            RongCloud rc = new RongCloud(appKey, appSecret, config);
            rongCloud.putIfAbsent(appKey + "_" + appSecret, rc);
            return rc;
        }
        return rongCloud.get(appKey + "_" + appSecret);
    }

    private static void checkAppKeyAndAppSecret(String appKey, String appSecret) {
        if (StringUtils.isBlank((CharSequence)appKey) || StringUtils.isBlank((CharSequence)appSecret)) {
            throw new IllegalArgumentException("'appKey' and 'appSecret' can not be null");
        }
    }

    public static RongCloud getInstance(String appKey, String appSecret, String apiHost, String ... apiHosts) {
        RongCloud.checkAppKeyAndAppSecret(appKey, appSecret);
        if (StringUtils.isBlank((CharSequence)apiHost)) {
            throw new IllegalArgumentException("'apiHost' can not be null");
        }
        return RongCloud.getInstance(appKey, appSecret, new RongCloudConfig(apiHost, apiHosts));
    }
}

