/*
 * Decompiled with CFR 0.152.
 */
package io.rong.example.chatroom;

import io.rong.CenterEnum;
import io.rong.RongCloud;
import io.rong.methods.chatroom.Chatroom;
import io.rong.models.chatroom.ChatroomDataModel;
import io.rong.models.chatroom.ChatroomMember;
import io.rong.models.chatroom.ChatroomModel;
import io.rong.models.response.ChatroomQueryResult;
import io.rong.models.response.ChatroomUserQueryResult;
import io.rong.models.response.CheckChatRoomUserResult;
import io.rong.models.response.CheckChatRoomUsersResult;
import io.rong.models.response.ResponseResult;

public class ChatroomExample {
    private static final String appKey = "appKey";
    private static final String appSecret = "appSecret";

    public static void main(String[] args) throws Exception {
        RongCloud rongCloud = RongCloud.getInstance(appKey, appSecret, CenterEnum.BJ);
        Chatroom chatroom = rongCloud.chatroom;
        ChatroomModel[] chatrooms = new ChatroomModel[]{new ChatroomModel().setId("chatroomId1").setName("chatroomName1"), new ChatroomModel().setId("chatroomId2").setName("chatroomName2")};
        ResponseResult result = chatroom.create(chatrooms);
        System.out.println("create:  " + result.toString());
        ChatroomDataModel chatroomDataModel = new ChatroomDataModel().setId("chatroomId3");
        ResponseResult result2 = chatroom.createV2(chatroomDataModel);
        System.out.println("createV2:  " + result2.toString());
        ChatroomQueryResult queryResult = chatroom.query(new ChatroomModel().setId("chatroomId3"));
        System.out.println("query:  " + queryResult.toString());
        ChatroomModel chatroomModel = new ChatroomModel().setId("d7ec7a8b8d8546c98b0973417209a548");
        chatroomModel = new ChatroomModel().setId("chatroomId1").setCount(500).setOrder(1);
        ChatroomUserQueryResult chatroomQueryUserResult = chatroom.get(chatroomModel);
        System.out.println("queryUser:  " + chatroomQueryUserResult.toString());
        ChatroomMember member = new ChatroomMember().setId("76894").setChatroomId("76891");
        CheckChatRoomUserResult checkMemberResult = chatroom.isExist(member);
        System.out.println("checkChatroomUserResult:  " + checkMemberResult.isInChrm);
        ChatroomMember[] members = new ChatroomMember[]{new ChatroomMember().setId("qawr34h"), new ChatroomMember().setId("qawr35h")};
        ChatroomModel exists = new ChatroomModel().setId("chrm01").setMembers(members);
        CheckChatRoomUsersResult result1 = chatroom.isExists(exists);
        System.out.println("checkChatroomUsersResult:  " + result1);
    }
}

