/*
 * Decompiled with CFR 0.152.
 */
package io.rong.example.profile;

import io.rong.CenterEnum;
import io.rong.RongCloud;
import io.rong.methods.profile.EntrustGroup;
import io.rong.models.profile.CreateEntrustGroupModel;
import io.rong.models.profile.EntrustGroupModel;
import io.rong.models.profile.GroupRemarkNameModel;
import io.rong.models.profile.ImportEntrustGroupModel;
import io.rong.models.profile.KickOutEntrustGroupModel;
import io.rong.models.profile.MemberInfoModel;
import io.rong.models.profile.PageModel;
import io.rong.models.profile.PagingQueryMembersModel;
import io.rong.models.profile.QueryJoinedGroupsModel;
import io.rong.models.profile.QuitEntrustGroupModel;
import io.rong.models.profile.TransferOwnerModel;
import io.rong.models.response.FollowedMemberResult;
import io.rong.models.response.JoinGroupResult;
import io.rong.models.response.PagingQueryGroupsResult;
import io.rong.models.response.PagingQueryJoinedGroupsResult;
import io.rong.models.response.PagingQueryMembersResult;
import io.rong.models.response.QueryGroupProfilesResult;
import io.rong.models.response.QueryMembersResult;
import io.rong.models.response.RemarkNameResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.response.SetManagersResult;
import java.util.HashMap;

public class EntrustGroupExample {
    private static final String APP_KEY = "appKey";
    private static final String APP_SECRET = "appSecret";
    private static EntrustGroup entrustGroup = RongCloud.getInstance((String)"appKey", (String)"appSecret", (CenterEnum)CenterEnum.BJ).entrustGroup;

    public static void main(String[] args) throws Exception {
        EntrustGroupExample.createExample();
        EntrustGroupExample.updateExample();
        EntrustGroupExample.queryProfilesExample();
        EntrustGroupExample.quitExample();
        EntrustGroupExample.kickOutExample();
        EntrustGroupExample.kickOutAllGroupExample();
        EntrustGroupExample.dismissExample();
        EntrustGroupExample.joinExample();
        EntrustGroupExample.transferOwnerExample();
        EntrustGroupExample.importGroupExample();
        EntrustGroupExample.setManagersExample();
        EntrustGroupExample.removeManagersExample();
        EntrustGroupExample.pagingQueryMembersExample();
        EntrustGroupExample.queryMembersByUserIdsExample();
        EntrustGroupExample.setMemberInfoExample();
        EntrustGroupExample.setGroupRemarkName();
        EntrustGroupExample.delGroupRemarkName();
        EntrustGroupExample.queryGroupRemarkName();
        EntrustGroupExample.followMemberExample();
        EntrustGroupExample.unfollowMemberExample();
        EntrustGroupExample.getFollowedMemberExample();
        EntrustGroupExample.pagingQueryGroupsExample();
        EntrustGroupExample.pagingQueryJoinedGroupsExample();
    }

    private static void pagingQueryJoinedGroupsExample() throws Exception {
        QueryJoinedGroupsModel pageModel = new QueryJoinedGroupsModel();
        pageModel.setUserId("uid1");
        pageModel.setRole(2);
        pageModel.setOrder(1);
        pageModel.setSize(20);
        pageModel.setPageToken("");
        PagingQueryJoinedGroupsResult result = entrustGroup.pagingQueryJoinedGroups(pageModel);
        System.out.println(result);
    }

    private static void pagingQueryGroupsExample() throws Exception {
        PageModel pageModel = new PageModel();
        pageModel.setOrder(1);
        pageModel.setSize(20);
        pageModel.setPageToken("");
        PagingQueryGroupsResult result = entrustGroup.pagingQueryGroups(pageModel);
        System.out.println(result);
    }

    private static void followMemberExample() throws Exception {
        ResponseResult result = entrustGroup.followMember("gid", "uid1", "uid2", "uid3");
        System.out.println(result);
    }

    private static void unfollowMemberExample() throws Exception {
        ResponseResult result = entrustGroup.unfollowMember("gid1", "uid1", "uid2", "uid3");
        System.out.println(result);
    }

    private static void getFollowedMemberExample() throws Exception {
        FollowedMemberResult result = entrustGroup.getFollowedMember("gid", "uid1");
        System.out.println(result);
    }

    private static void queryGroupRemarkName() throws Exception {
        RemarkNameResult result = entrustGroup.queryRemarkName("gid", "uid1");
        System.out.println(result);
    }

    private static void delGroupRemarkName() throws Exception {
        ResponseResult result = entrustGroup.delRemarkName("gid", "uid1");
        System.out.println(result);
    }

    private static void setGroupRemarkName() throws Exception {
        GroupRemarkNameModel remarkNameModel = new GroupRemarkNameModel();
        remarkNameModel.setGroupId("gid");
        remarkNameModel.setUserId("uid1");
        remarkNameModel.setRemarkName("name1");
        ResponseResult result = entrustGroup.setRemarkName(remarkNameModel);
        System.out.println(result);
    }

    private static void setMemberInfoExample() throws Exception {
        MemberInfoModel memberInfoModel = new MemberInfoModel();
        memberInfoModel.setGroupId("gid");
        memberInfoModel.setUserId("uid1");
        memberInfoModel.setNickname("nickname1");
        memberInfoModel.setExtra("ext");
        ResponseResult result = entrustGroup.setMemberInfo(memberInfoModel);
        System.out.println(result);
    }

    private static void queryMembersByUserIdsExample() throws Exception {
        QueryMembersResult result = entrustGroup.queryMembersByUserIds("gid", "uid1", "uid2");
        System.out.println(result);
    }

    private static void pagingQueryMembersExample() throws Exception {
        PagingQueryMembersModel pagingQueryMembersModel = new PagingQueryMembersModel();
        pagingQueryMembersModel.setGroupId("gid");
        pagingQueryMembersModel.setType(1);
        pagingQueryMembersModel.setPageToken("");
        pagingQueryMembersModel.setSize(10);
        pagingQueryMembersModel.setOrder(1);
        PagingQueryMembersResult result = entrustGroup.pagingQueryMembers(pagingQueryMembersModel);
        System.out.println(result);
    }

    private static void setManagersExample() throws Exception {
        SetManagersResult result = entrustGroup.addManagers("gid1", "uid1", "uid2");
        System.out.println(result);
    }

    private static void removeManagersExample() throws Exception {
        ResponseResult result = entrustGroup.removeManagers("gid1", "uid1", "uid2", "uid2", "uid0");
        System.out.println(result);
    }

    private static void importGroupExample() throws Exception {
        ImportEntrustGroupModel groupModel = new ImportEntrustGroupModel();
        HashMap<String, String> groupProfile = new HashMap<String, String>();
        groupProfile.put("portraitUrl", "http://test_url");
        HashMap<String, String> groupExtProfile = new HashMap<String, String>();
        groupExtProfile.put("ext_00", "vvv1");
        groupExtProfile.put("ext_11", "vvv2");
        HashMap<String, Integer> permissions = new HashMap<String, Integer>();
        permissions.put("joinPerm", 1);
        groupModel.setGroupId("group1").setName("groupName").setOwner("user1").setGroupProfile(groupProfile).setGroupExtProfile(groupExtProfile).setPermissions(permissions);
        ResponseResult responseResult = entrustGroup.importGroup(groupModel);
        System.out.println(responseResult);
    }

    private static void transferOwnerExample() throws Exception {
        ResponseResult result = entrustGroup.transferOwner(new TransferOwnerModel().setGroupId("gid").setNewOwner("uid1").setIsDelBan(1).setIsDelFollowed(1).setIsDelWhite(1).setIsQuit(1));
        System.out.println(result);
    }

    private static void joinExample() throws Exception {
        JoinGroupResult result = entrustGroup.join("gid1", "uid1", "uid2");
        System.out.println(result);
    }

    private static void dismissExample() throws Exception {
        ResponseResult result = entrustGroup.dismiss("gid1");
        System.out.println(result);
    }

    private static void kickOutAllGroupExample() throws Exception {
        ResponseResult result = entrustGroup.kickOutAllGroups("uid1");
        System.out.println(result);
    }

    private static void kickOutExample() throws Exception {
        KickOutEntrustGroupModel params = new KickOutEntrustGroupModel();
        params.setGroupId("group1");
        params.setIsDelBan(1);
        params.setIsDelFollowed(1);
        params.setIsDelWhite(1);
        params.setUserIds(new String[]{"uid1", "uid2"});
        ResponseResult result = entrustGroup.kickOut(params);
        System.out.println(result);
    }

    private static void quitExample() throws Exception {
        QuitEntrustGroupModel params = new QuitEntrustGroupModel().setGroupId("group1").setIsDelBan(2).setIsDelFollowed(1).setIsDelWhite(1).setUserIds(new String[]{"uid1", "uid2"});
        ResponseResult result = entrustGroup.quit(params);
        System.out.println(result);
    }

    private static void queryProfilesExample() throws Exception {
        QueryGroupProfilesResult result = entrustGroup.queryProfiles("group1", "group2");
        System.out.println(result);
    }

    private static void createExample() throws Exception {
        CreateEntrustGroupModel groupModel = new CreateEntrustGroupModel();
        HashMap<String, String> groupProfile = new HashMap<String, String>();
        groupProfile.put("portraitUrl", "http://test_url");
        HashMap<String, String> groupExtProfile = new HashMap<String, String>();
        groupExtProfile.put("ext_00", "vvv1");
        groupExtProfile.put("ext_11", "vvv2");
        HashMap<String, Integer> permissions = new HashMap<String, Integer>();
        permissions.put("joinPerm", 1);
        groupModel.setGroupId("group1").setName("groupName").setOwner("user1").setGroupProfile(groupProfile).setGroupExtProfile(groupExtProfile).setPermissions(permissions);
        groupModel.setUserIds(new String[]{"uid1", "uid2"});
        ResponseResult responseResult = entrustGroup.create(groupModel);
        System.out.println(responseResult);
    }

    private static void updateExample() throws Exception {
        EntrustGroupModel groupModel = new EntrustGroupModel();
        HashMap<String, String> groupProfile = new HashMap<String, String>();
        groupProfile.put("portraitUrl", "http://test_url");
        HashMap<String, String> groupExtProfile = new HashMap<String, String>();
        groupExtProfile.put("ext_01", "v1");
        groupExtProfile.put("ext_02", "v2");
        HashMap<String, Integer> permissions = new HashMap<String, Integer>();
        permissions.put("joinPerm", 1);
        groupModel.setGroupId("group1").setName("groupName").setOwner("user1").setGroupProfile(groupProfile).setGroupExtProfile(groupExtProfile).setPermissions(permissions);
        ResponseResult responseResult = entrustGroup.updateProfile(groupModel);
        System.out.println(responseResult);
    }
}

