/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods;

import io.rong.RongCloud;
import io.rong.models.response.ResponseResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class BaseMethod {
    private static final String UTF8 = "UTF-8";
    protected static final String CONTENT_TYPE_JSON = "application/json";
    protected static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
    protected String appKey;
    protected String appSecret;
    protected RongCloud rongCloud;
    protected String path;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    protected void addFormParam(StringBuilder sb, String paramName, Object param) throws UnsupportedEncodingException {
        if (param == null) {
            return;
        }
        if (param instanceof String && StringUtils.isNotBlank((CharSequence)((String)param))) {
            sb.append(paramName).append(URLEncoder.encode((String)param, UTF8));
        } else if (BaseMethod.isBasicType(param)) {
            sb.append(paramName).append(URLEncoder.encode(String.valueOf(param), UTF8));
        } else {
            sb.append(paramName).append(URLEncoder.encode(GsonUtil.toJson(param), UTF8));
        }
    }

    protected String getJsonBody(Object param) {
        if (param == null) {
            return "{}";
        }
        return GsonUtil.toJson(param);
    }

    protected abstract void initPath();

    protected <T extends ResponseResult> T doRequest(String uri, String body, String method, Class<T> respClass) throws Exception {
        return this.doRequest(uri, body, method, respClass, CONTENT_TYPE_FORM);
    }

    protected <T extends ResponseResult> T doRequest(String uri, String body, String method, Class<T> respClass, String contentType) throws Exception {
        ResponseResult result;
        String response = null;
        if (body.startsWith("&")) {
            body = body.substring(1);
        }
        try {
            HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, uri, contentType);
            HttpUtil.setBodyParameter(body, conn, this.rongCloud.getConfig());
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(respClass, CommonUtil.getResponseByCode(this.path, method, response));
            if (result.getCode() == null) {
                throw new RuntimeException(response);
            }
        }
        catch (Exception e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = (ResponseResult)GsonUtil.fromJson(respClass, new ResponseResult(500, "uri=" + uri + "  response=" + response + "   errorInfo=" + e.getClass().getSimpleName() + ":" + e.getMessage()).toString());
        }
        result.setReqBody(body);
        return (T)result;
    }

    protected <T extends ResponseResult> T doGetRequest(String uri, Class<T> respClass) {
        ResponseResult result;
        String response = "";
        try {
            HttpURLConnection conn = HttpUtil.createGetHttpConnection(this.rongCloud.getConfig(), this.appKey, this.appSecret, uri);
            response = HttpUtil.returnResult(conn, this.rongCloud.getConfig());
            result = (ResponseResult)GsonUtil.fromJson(respClass, CommonUtil.getResponseByCode(this.path, "", response));
            if (result.getCode() == null) {
                throw new RuntimeException(response);
            }
        }
        catch (Exception e) {
            this.rongCloud.getConfig().errorCounter.incrementAndGet();
            result = (ResponseResult)GsonUtil.fromJson(respClass, new ResponseResult(500, "uri=" + uri + "  response=" + response + "   errorInfo=" + e.getClass().getSimpleName() + ":" + e.getMessage()).toString());
        }
        return (T)result;
    }

    protected String[] removeDuplicates(String[] params) {
        if (params == null || params.length == 0) {
            return new String[0];
        }
        LinkedHashSet<String> uniqueSet = new LinkedHashSet<String>(Arrays.asList(params));
        return uniqueSet.toArray(new String[0]);
    }

    protected List<String> removeDuplicates(List<String> params) {
        if (params == null) {
            return Collections.emptyList();
        }
        LinkedHashSet<String> uniqueElements = new LinkedHashSet<String>(params);
        return new ArrayList<String>(uniqueElements);
    }

    protected <T extends ResponseResult> T checkFiled(Object model, String method, Class<T> respClass) {
        String message = CommonUtil.checkFiled(model, this.path, method, true);
        if (message != null) {
            return (T)((ResponseResult)GsonUtil.fromJson(respClass, message));
        }
        return null;
    }

    protected <T extends ResponseResult> T checkParam(String paramName, Object value, String method, Class<T> respClass) {
        String message = CommonUtil.checkParam(paramName, value, this.path, method, true);
        if (message != null) {
            return (T)((ResponseResult)GsonUtil.fromJson(respClass, message));
        }
        return null;
    }

    public static boolean isBasicType(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> clazz = obj.getClass();
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz.equals(Boolean.class) || clazz.equals(Character.class) || clazz.equals(Byte.class) || clazz.equals(Short.class) || clazz.equals(Integer.class) || clazz.equals(Long.class) || clazz.equals(Float.class) || clazz.equals(Double.class) || clazz.equals(String.class);
    }
}

